/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.utils;

import java.util.Map;
import net.neoforged.neoform.runtime.utils.AnsiColor;

public final class Logger {
    private static final Map<Character, String> EMOJI_MAP = Map.of(Character.valueOf('\u2193'), "DL   ", Character.valueOf('\u267b'), "REUSE", Character.valueOf('\u2713'), "DONE ", Character.valueOf('\u21b3'), "RUN  ");
    public static boolean NO_COLOR;
    public static boolean NO_EMOJIS;
    public static boolean PRINT_THREAD;
    private static IndeterminateSpinner spinner;

    public static Logger create() {
        return new Logger();
    }

    public void warn(String message) {
        this.println("  " + String.valueOf((Object)AnsiColor.YELLOW) + "WARNING: " + String.valueOf((Object)AnsiColor.RESET) + message);
    }

    public void println(String text) {
        this.closeSpinner();
        if (PRINT_THREAD) {
            System.out.print(Logger.cleanText(String.valueOf((Object)AnsiColor.MUTED) + "[" + ProcessHandle.current().pid() + ":" + Thread.currentThread().threadId() + "] " + String.valueOf((Object)AnsiColor.RESET)));
        }
        System.out.println(Logger.cleanText(text));
    }

    private void closeSpinner() {
        if (spinner != null) {
            spinner.end();
            spinner = null;
            System.out.println();
        }
    }

    public IndeterminateSpinner spinner(String message) {
        this.closeSpinner();
        System.out.print(Logger.cleanText(message));
        spinner = new IndeterminateSpinner();
        return spinner;
    }

    private static String cleanText(String text) {
        if (!NO_COLOR && !NO_EMOJIS) {
            return text;
        }
        StringBuilder result = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (NO_COLOR && ch == '\u001b') {
                ++i;
                while (i < text.length() && text.charAt(i) != 'm') {
                    ++i;
                }
                continue;
            }
            if (NO_EMOJIS && ch >= '\u007f') {
                result.append(EMOJI_MAP.getOrDefault(Character.valueOf(ch), "."));
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static class IndeterminateSpinner {
        String[] spinners = new String[]{"", ".", "..", "..."};
        String lastTextPrinted = "";
        int spinnerIndex = 0;

        public IndeterminateSpinner() {
            this.tick();
        }

        public void tick() {
            if (!this.lastTextPrinted.isEmpty()) {
                System.out.print("\b".repeat(this.lastTextPrinted.length()));
            }
            this.lastTextPrinted = this.spinners[++this.spinnerIndex % this.spinners.length];
            System.out.print(this.lastTextPrinted);
        }

        public void end() {
            if (spinner == this) {
                System.out.print("\b".repeat(this.lastTextPrinted.length()));
                this.lastTextPrinted = "";
                spinner = null;
            }
        }
    }
}

