/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.graph;

import java.nio.file.Path;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.neoforged.neoform.runtime.graph.ExecutionNodeAction;
import net.neoforged.neoform.runtime.graph.NodeInput;
import net.neoforged.neoform.runtime.graph.NodeOutput;
import net.neoforged.neoform.runtime.graph.NodeState;
import net.neoforged.neoform.runtime.utils.AnsiColor;
import net.neoforged.neoform.runtime.utils.Logger;

public final class ExecutionNode {
    private static final Logger LOG = Logger.create();
    private final String id;
    private final Map<String, NodeInput> inputs;
    private final Map<String, NodeOutput> outputs;
    private ExecutionNodeAction action;
    private Set<ExecutionNode> predecessors = Set.of();
    private Long started;
    private long elapsedMs;
    private NodeState state = NodeState.NOT_STARTED;

    public ExecutionNode(String id, Map<String, NodeInput> inputs, Map<String, NodeOutput> outputs, ExecutionNodeAction action) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(action, "action");
        inputs = Map.copyOf(inputs);
        for (Map.Entry<String, NodeInput> entry : inputs.entrySet()) {
            entry.getValue().setNode(this);
            entry.getValue().setId(entry.getKey());
        }
        outputs = Map.copyOf(outputs);
        for (NodeOutput output : outputs.values()) {
            output.setNode(this);
        }
        this.id = id;
        this.inputs = inputs;
        this.outputs = outputs;
        this.action = action;
        this.updatePredecessors();
    }

    void updatePredecessors() {
        Set predecessors = Collections.newSetFromMap(new IdentityHashMap());
        for (NodeInput value : this.inputs.values()) {
            predecessors.addAll(value.getNodeDependencies());
        }
        this.predecessors = Collections.unmodifiableSet(predecessors);
    }

    public void start() {
        if (this.state != NodeState.NOT_STARTED) {
            throw new IllegalStateException("Node " + String.valueOf(this) + " already started.");
        }
        this.started = System.currentTimeMillis();
        this.state = NodeState.STARTED;
        String underlinedId = String.valueOf((Object)AnsiColor.UNDERLINE) + this.id() + String.valueOf((Object)AnsiColor.RESET);
        LOG.println(String.valueOf((Object)AnsiColor.BOLD) + "*** Started working on " + underlinedId + String.valueOf((Object)AnsiColor.RESET));
    }

    public void fail() {
        if (this.started != null) {
            this.elapsedMs = System.currentTimeMillis() - this.started;
        }
        this.state = NodeState.FAILED;
    }

    public void complete(Map<String, Path> outputs, boolean fromCache) {
        if (this.state != NodeState.STARTED) {
            throw new IllegalStateException("Node " + String.valueOf(this) + " not started yet.");
        }
        for (Map.Entry<String, Path> entry : outputs.entrySet()) {
            NodeOutput output = this.outputs.get(entry.getKey());
            if (output == null) {
                throw new IllegalArgumentException("Trying to set output " + entry.getKey() + " which does not exist on " + String.valueOf(this));
            }
            output.setResultPath(entry.getValue());
        }
        for (String outputId : this.outputs.keySet()) {
            if (outputs.containsKey(outputId)) continue;
            throw new IllegalArgumentException("No value for output " + outputId + " provided for node " + String.valueOf(this));
        }
        this.state = NodeState.COMPLETED;
        this.elapsedMs = System.currentTimeMillis() - this.started;
        String elapsedStr = String.format(Locale.ROOT, "%.02f", (double)this.elapsedMs / 1000.0) + "s";
        String underlinedId = String.valueOf((Object)AnsiColor.UNDERLINE) + this.id() + String.valueOf((Object)AnsiColor.RESET);
        if (fromCache) {
            LOG.println(" " + String.valueOf((Object)AnsiColor.BOLD) + String.valueOf((Object)AnsiColor.BRIGHT_GREEN) + "\u267b" + String.valueOf((Object)AnsiColor.RESET) + " Used cache of " + underlinedId + " in " + elapsedStr);
        } else {
            LOG.println(" " + String.valueOf((Object)AnsiColor.BOLD) + String.valueOf((Object)AnsiColor.BRIGHT_GREEN) + "\u2713" + String.valueOf((Object)AnsiColor.RESET) + " Completed " + underlinedId + " in " + elapsedStr);
        }
    }

    public NodeState getState() {
        return this.state;
    }

    public String id() {
        return this.id;
    }

    public NodeInput getRequiredInput(String id) {
        NodeInput result = this.inputs.get(id);
        if (result == null) {
            throw new IllegalArgumentException("Input '" + id + "' does not exist on node '" + String.valueOf(this) + "'");
        }
        return result;
    }

    public void setInput(String id, NodeInput input) {
        this.inputs.put(id, Objects.requireNonNull(input, "input"));
        this.updatePredecessors();
    }

    public Map<String, NodeInput> inputs() {
        return this.inputs;
    }

    public boolean hasInput(String id) {
        return this.inputs.containsKey(id);
    }

    public boolean hasOutput(String id) {
        return this.outputs.containsKey(id);
    }

    public NodeOutput getRequiredOutput(String id) {
        NodeOutput result = this.outputs.get(id);
        if (result == null) {
            throw new IllegalArgumentException("Output " + id + " does not exist on node " + String.valueOf(this));
        }
        return result;
    }

    public Map<String, NodeOutput> outputs() {
        return this.outputs;
    }

    public ExecutionNodeAction action() {
        return this.action;
    }

    public String toString() {
        return this.id;
    }

    public Set<ExecutionNode> getPredecessors() {
        return this.predecessors;
    }

    public void setAction(ExecutionNodeAction action) {
        this.action = Objects.requireNonNull(action, "action");
    }
}

