/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.config.neoform;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.neoforged.neoform.runtime.config.neoform.NeoFormDistConfig;
import net.neoforged.neoform.runtime.config.neoform.NeoFormFunction;
import net.neoforged.neoform.runtime.config.neoform.NeoFormStep;
import net.neoforged.neoform.runtime.config.neoform.NeoFormStepDeserializer;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;
import org.jetbrains.annotations.Nullable;

public record NeoFormConfig(int spec, @SerializedName(value="version") String minecraftVersion, boolean official, @SerializedName(value="java_target") int javaVersion, String encoding, Map<String, Object> data, Map<String, List<NeoFormStep>> steps, Map<String, NeoFormFunction> functions, Map<String, List<MavenCoordinate>> libraries) {
    public NeoFormDistConfig getDistConfig(String dist) {
        if (!this.steps.containsKey(dist)) {
            throw new IllegalArgumentException("This configuration does not include the distribution " + dist + ". Available: " + String.valueOf(this.steps.keySet()));
        }
        return new NeoFormDistConfig(this, dist);
    }

    public static NeoFormConfig from(ZipFile zipFile) throws IOException {
        byte[] configContent;
        ZipEntry configEntry = zipFile.getEntry("config.json");
        if (configEntry == null || configEntry.isDirectory()) {
            throw new IOException("NeoForm config file config.json not found in " + zipFile.getName());
        }
        try (InputStream in = zipFile.getInputStream(configEntry);){
            configContent = in.readAllBytes();
        }
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)NeoFormStep.class), new NeoFormStepDeserializer()).registerTypeAdapter((Type)((Object)MavenCoordinate.class), MavenCoordinate.TYPE_ADAPTER).create();
        JsonObject root = gson.fromJson((Reader)new StringReader(new String(configContent, StandardCharsets.UTF_8)), JsonObject.class);
        try {
            return gson.fromJson((JsonElement)root, NeoFormConfig.class);
        }
        catch (JsonSyntaxException e) {
            throw new IOException("Failed to read NeoForm config from " + zipFile.getName(), e);
        }
    }

    @Nullable
    public String getDataPathInZip(String name, String dist) {
        Object dataSpec = this.data.get(name);
        if (dataSpec == null) {
            return null;
        }
        if (dataSpec instanceof String) {
            String stringValue = (String)dataSpec;
            return stringValue;
        }
        if (dataSpec instanceof Map) {
            Map mapValue = (Map)dataSpec;
            return (String)mapValue.get(dist);
        }
        throw new UnsupportedOperationException("Unsupported data type " + dataSpec.getClass().getName() + " for data " + name);
    }
}

