/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import net.neoforged.neoform.runtime.graph.ExecutionNodeAction;
import net.neoforged.srgutils.IMappingFile;

public class RemapSrgSourcesAction
implements ExecutionNodeAction {
    private static final Pattern SRG_FINDER = Pattern.compile("[fF]unc_\\d+_[a-zA-Z_]+|m_\\d+_|[fF]ield_\\d+_[a-zA-Z_]+|f_\\d+_");

    @Override
    public void run(ProcessingEnvironment environment) throws IOException, InterruptedException {
        Path officialMappingsPath = environment.getRequiredInputPath("officialMappings");
        Path mergeMappingsPath = environment.getRequiredInputPath("mergedMappings");
        IMappingFile srgMappings = IMappingFile.load(mergeMappingsPath.toFile()).reverse();
        IMappingFile officialMappings = IMappingFile.load(officialMappingsPath.toFile()).reverse();
        IMappingFile srgToOfficial = srgMappings.chain(officialMappings);
        HashMap<String, String> srgNamesToOfficial = new HashMap<String, String>();
        for (IMappingFile.IClass iClass : srgToOfficial.getClasses()) {
            for (IMappingFile.IField iField : iClass.getFields()) {
                srgNamesToOfficial.put(iField.getOriginal(), iField.getMapped());
            }
            for (IMappingFile.IMethod iMethod : iClass.getMethods()) {
                srgNamesToOfficial.put(iMethod.getOriginal(), iMethod.getMapped());
            }
        }
        Path sourcesPath = environment.getRequiredInputPath("sources");
        Path path = environment.getOutputPath("output");
        try (ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(Files.newInputStream(sourcesPath, new OpenOption[0])));
             ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0])));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                zipOutputStream.putNextEntry(entry);
                if (entry.getName().endsWith(".java")) {
                    String sourceCode = new String(zipIn.readAllBytes(), StandardCharsets.UTF_8);
                    String mappedSource = RemapSrgSourcesAction.mapSourceCode(sourceCode, srgNamesToOfficial);
                    zipOutputStream.write(mappedSource.getBytes(StandardCharsets.UTF_8));
                } else {
                    zipIn.transferTo(zipOutputStream);
                }
                zipOutputStream.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
    }

    private static String mapSourceCode(String sourceCode, HashMap<String, String> srgNamesToOfficial) {
        Matcher m = SRG_FINDER.matcher(sourceCode);
        return m.replaceAll(matchResult -> {
            String matched = matchResult.group();
            String mapped = srgNamesToOfficial.getOrDefault(matched, matched);
            return Matcher.quoteReplacement(mapped);
        });
    }
}

