/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import net.neoforged.neoform.runtime.actions.BuiltInAction;
import net.neoforged.neoform.runtime.actions.ExtensibleClasspath;
import net.neoforged.neoform.runtime.artifacts.ClasspathItem;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import net.neoforged.neoform.runtime.graph.ExecutionNodeAction;
import net.neoforged.neoform.runtime.graph.ResultRepresentation;
import net.neoforged.neoform.runtime.manifests.MinecraftVersionManifest;

public abstract class RecompileSourcesAction
extends BuiltInAction
implements ExecutionNodeAction {
    private final ExtensibleClasspath classpath = new ExtensibleClasspath();
    private final ExtensibleClasspath sourcepath = new ExtensibleClasspath();
    private int targetJavaVersion = 21;

    @Override
    public void computeCacheKey(CacheKeyBuilder ck) {
        super.computeCacheKey(ck);
        this.classpath.computeCacheKey("compile classpath", ck);
        this.sourcepath.computeCacheKey("compile sourcepath", ck);
        ck.add("target java version", String.valueOf(this.targetJavaVersion));
    }

    protected final List<Path> getEffectiveClasspath(ProcessingEnvironment environment) throws IOException {
        MinecraftVersionManifest versionManifest = environment.getRequiredInput("versionManifest", ResultRepresentation.MINECRAFT_VERSION_MANIFEST);
        List<ClasspathItem> effectiveClasspathItems = this.classpath.mergeWithMinecraftLibraries(versionManifest).getEffectiveClasspath();
        List<Path> classpath = environment.getArtifactManager().resolveClasspath(effectiveClasspathItems);
        LOG.println(" " + classpath.size() + " items on the compile classpath");
        return classpath;
    }

    protected final List<Path> getEffectiveSourcepath(ProcessingEnvironment environment) throws IOException {
        ExtensibleClasspath effectiveClasspath = this.sourcepath.copy();
        List<ClasspathItem> effectiveItems = effectiveClasspath.getEffectiveClasspath();
        List<Path> sourcepath = environment.getArtifactManager().resolveClasspath(effectiveItems);
        LOG.println(" " + sourcepath.size() + " items on the sourcepath");
        return sourcepath;
    }

    public ExtensibleClasspath getClasspath() {
        return this.classpath;
    }

    public ExtensibleClasspath getSourcepath() {
        return this.sourcepath;
    }

    public int getTargetJavaVersion() {
        return this.targetJavaVersion;
    }

    public void setTargetJavaVersion(int targetJavaVersion) {
        this.targetJavaVersion = targetJavaVersion;
    }
}

