/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.graph.transforms;

import java.util.Map;
import net.neoforged.neoform.runtime.engine.NeoFormEngine;
import net.neoforged.neoform.runtime.graph.ExecutionGraph;
import net.neoforged.neoform.runtime.graph.ExecutionNode;
import net.neoforged.neoform.runtime.graph.ExecutionNodeBuilder;
import net.neoforged.neoform.runtime.graph.NodeInput;
import net.neoforged.neoform.runtime.graph.NodeOutput;
import net.neoforged.neoform.runtime.graph.transforms.GraphTransform;

public final class ReplaceNodeOutput
extends GraphTransform {
    private final String nodeId;
    private final String outputId;
    private final String newNodeId;
    private final NodeFactory nodeFactory;

    public ReplaceNodeOutput(String nodeId, String outputId, String newNodeId, NodeFactory nodeFactory) {
        this.nodeId = nodeId;
        this.outputId = outputId;
        this.newNodeId = newNodeId;
        this.nodeFactory = nodeFactory;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public String outputId() {
        return this.outputId;
    }

    @Override
    public void apply(NeoFormEngine engine, ExecutionGraph graph) {
        NodeOutput originalOutput = graph.getRequiredOutput(this.nodeId, this.outputId);
        ExecutionNodeBuilder builder = graph.nodeBuilder(this.newNodeId);
        NodeOutput newOutput = this.nodeFactory.make(builder, originalOutput);
        ExecutionNode newNode = builder.build();
        for (ExecutionNode executionNode : graph.getNodes()) {
            if (executionNode == newNode) continue;
            for (NodeInput nodeInput : executionNode.inputs().values()) {
                nodeInput.replaceReferences(originalOutput, newOutput);
            }
        }
        for (Map.Entry entry : graph.getResults().entrySet()) {
            if (entry.getValue() != originalOutput) continue;
            entry.setValue(newOutput);
        }
    }

    @FunctionalInterface
    public static interface NodeFactory {
        public NodeOutput make(ExecutionNodeBuilder var1, NodeOutput var2);
    }
}

