/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessGeneration {
    private static final MinecraftReleaseVersion MC_1_17_1 = new MinecraftReleaseVersion(1, 17, 1);
    private static final MinecraftReleaseVersion MC_1_20_1 = new MinecraftReleaseVersion(1, 20, 1);
    private static final MinecraftReleaseVersion MC_1_21_6 = new MinecraftReleaseVersion(1, 21, 6);
    private final List<String> additionalDenyListForMinecraftJars = new ArrayList<String>();
    private boolean sourcesUseIntermediaryNames;
    private boolean supportsSideAnnotationStripping;
    private boolean generateDistSourceManifest;

    static ProcessGeneration fromMinecraftVersion(String minecraftVersion) {
        MinecraftReleaseVersion releaseVersion = MinecraftReleaseVersion.parse(minecraftVersion);
        ProcessGeneration result = new ProcessGeneration();
        if (ProcessGeneration.isLessThanOrEqualTo(releaseVersion, MC_1_17_1)) {
            Collections.addAll(result.additionalDenyListForMinecraftJars, "com/mojang/(authlib|bridge|brigadier|datafixers|serialization|util)/.*", "com/google/.*", "joptsimple/.*", "com/sun/.*", "oshi/.*", "io/.*", "it/.*", "javax/.*", "org/.*");
        }
        result.sourcesUseIntermediaryNames = ProcessGeneration.isLessThanOrEqualTo(releaseVersion, MC_1_20_1);
        result.generateDistSourceManifest = ProcessGeneration.isGreaterThanOrEqualTo(releaseVersion, MC_1_21_6);
        result.supportsSideAnnotationStripping = ProcessGeneration.isLessThanOrEqualTo(releaseVersion, MC_1_20_1);
        return result;
    }

    private static boolean isLessThanOrEqualTo(@Nullable MinecraftReleaseVersion releaseVersion, MinecraftReleaseVersion version) {
        if (releaseVersion == null) {
            return false;
        }
        return releaseVersion.compareTo(version) <= 0;
    }

    private static boolean isGreaterThanOrEqualTo(@Nullable MinecraftReleaseVersion releaseVersion, MinecraftReleaseVersion version) {
        if (releaseVersion == null) {
            return true;
        }
        return releaseVersion.compareTo(version) >= 0;
    }

    public boolean sourcesUseIntermediaryNames() {
        return this.sourcesUseIntermediaryNames;
    }

    public boolean supportsSideAnnotationStripping() {
        return this.supportsSideAnnotationStripping;
    }

    public boolean generateDistSourceManifest() {
        return this.generateDistSourceManifest;
    }

    List<String> getAdditionalDenyListForMinecraftJars() {
        return this.additionalDenyListForMinecraftJars;
    }

    private record MinecraftReleaseVersion(int major, int minor, int patch) implements Comparable<MinecraftReleaseVersion>
    {
        private static final Comparator<MinecraftReleaseVersion> COMPARATOR = Comparator.comparingInt(MinecraftReleaseVersion::major).thenComparingInt(MinecraftReleaseVersion::minor).thenComparingInt(MinecraftReleaseVersion::patch);
        private static final Pattern RELEASE_VERSION = Pattern.compile("^(\\d+)\\.(\\d+)(?:\\.(\\d+))?$");

        @Nullable
        public static MinecraftReleaseVersion parse(String version) {
            Matcher m = RELEASE_VERSION.matcher(version);
            if (m.matches()) {
                return new MinecraftReleaseVersion(Integer.parseUnsignedInt(m.group(1)), Integer.parseUnsignedInt(m.group(2)), m.group(3) != null ? Integer.parseUnsignedInt(m.group(3)) : 0);
            }
            return null;
        }

        @Override
        public int compareTo(@NotNull MinecraftReleaseVersion o) {
            return COMPARATOR.compare(this, o);
        }
    }
}

