/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HexFormat;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.neoforged.neoform.runtime.actions.InjectSource;
import net.neoforged.neoform.runtime.cache.CacheKey;
import net.neoforged.neoform.runtime.cli.FileHashService;
import org.jetbrains.annotations.Nullable;

public class InjectFromZipFileSource
implements InjectSource {
    private final ZipFile zf;
    private final String sourcePath;
    @Nullable
    private final Pattern includeFilterPattern;
    private final ContentFilter contentFilter;

    public InjectFromZipFileSource(ZipFile zf, String sourcePath) {
        this(zf, sourcePath, null);
    }

    public InjectFromZipFileSource(ZipFile zf, String sourcePath, @Nullable Pattern includeFilterPattern) {
        this(zf, sourcePath, includeFilterPattern, null);
    }

    public InjectFromZipFileSource(ZipFile zf, String sourcePath, @Nullable Pattern includeFilterPattern, @Nullable ContentFilter contentFilter) {
        this.zf = zf;
        this.sourcePath = InjectFromZipFileSource.sanitizeSourcePath(sourcePath);
        this.includeFilterPattern = includeFilterPattern;
        this.contentFilter = Objects.requireNonNullElse(contentFilter, ContentFilter.NONE);
    }

    private static String sanitizeSourcePath(String sourcePath) {
        while (((String)sourcePath).startsWith("/")) {
            sourcePath = ((String)sourcePath).substring(1);
        }
        if (!((String)sourcePath).isEmpty() && !((String)sourcePath).endsWith("/")) {
            sourcePath = (String)sourcePath + "/";
        }
        return sourcePath;
    }

    @Override
    public CacheKey.AnnotatedValue getCacheKey(FileHashService fileHashService) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        DigestOutputStream digestStream = new DigestOutputStream(OutputStream.nullOutputStream(), digest);
        Enumeration<? extends ZipEntry> entries = this.zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!this.sourcePath.isEmpty() && !entry.getName().startsWith(this.sourcePath) || !this.matchesIncludeFilter(entry)) continue;
            digestStream.write(entry.getName().getBytes());
            InputStream in = this.zf.getInputStream(entry);
            try {
                this.contentFilter.copy(entry, in, digestStream);
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
        return new CacheKey.AnnotatedValue(HexFormat.of().formatHex(digest.digest()), this.sourcePath + " from " + this.zf.getName() + (String)(this.includeFilterPattern == null ? "" : " matching " + this.includeFilterPattern.pattern()));
    }

    @Override
    public byte @Nullable [] tryReadFile(String path) throws IOException {
        ZipEntry entry = this.zf.getEntry(this.sourcePath + path);
        if (entry != null) {
            try (InputStream in = this.zf.getInputStream(entry);){
                byte[] byArray = in.readAllBytes();
                return byArray;
            }
        }
        return null;
    }

    @Override
    public void copyTo(ZipOutputStream out) throws IOException {
        Enumeration<? extends ZipEntry> entries = this.zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!this.sourcePath.isEmpty() && !entry.getName().startsWith(this.sourcePath) || !this.matchesIncludeFilter(entry)) continue;
            try {
                InputStream in = this.zf.getInputStream(entry);
                try {
                    ZipEntry copiedEntry = new ZipEntry(entry.getName().substring(this.sourcePath.length()));
                    if (copiedEntry.getName().isEmpty()) continue;
                    copiedEntry.setMethod(entry.getMethod());
                    copiedEntry.setCrc(entry.getCrc());
                    copiedEntry.setSize(entry.getSize());
                    copiedEntry.setTime(entry.getTime());
                    out.putNextEntry(copiedEntry);
                    this.contentFilter.copy(entry, in, out);
                    out.closeEntry();
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (ZipException e) {
                if (!e.getMessage().startsWith("duplicate entry:")) {
                    throw e;
                }
                if (entry.isDirectory()) continue;
                System.err.println("Cannot inject duplicate file " + entry.getName());
            }
        }
    }

    private boolean matchesIncludeFilter(ZipEntry entry) {
        return this.includeFilterPattern == null || this.includeFilterPattern.matcher(entry.getName()).matches();
    }

    @FunctionalInterface
    public static interface ContentFilter {
        public static final ContentFilter NONE = (entry, in, out) -> in.transferTo(out);

        public void copy(ZipEntry var1, InputStream var2, OutputStream var3) throws IOException;
    }
}

