/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.neoforged.neoform.runtime.actions.BuiltInAction;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import net.neoforged.srgutils.IMappingFile;
import org.jetbrains.annotations.Nullable;

public final class SplitResourcesFromClassesAction
extends BuiltInAction {
    public static final String INPUT_OTHER_DIST_JAR = "otherDistJar";
    public static final String INPUT_MAPPINGS = "mappings";
    private static final LocalDateTime MANIFEST_TIME = LocalDateTime.of(2000, 1, 1, 0, 0, 0, 0);
    private final List<Pattern> denyListPatterns = new ArrayList<Pattern>();
    @Nullable
    private GenerateDistManifestSettings generateDistManifestSettings;

    @Override
    public void run(ProcessingEnvironment environment) throws IOException, InterruptedException {
        Path inputJar = environment.getRequiredInputPath("input");
        Path otherDistJarPath = null;
        Path mappingsPath = null;
        if (this.generateDistManifestSettings != null) {
            otherDistJarPath = environment.getRequiredInputPath(INPUT_OTHER_DIST_JAR);
            mappingsPath = environment.getInputPath(INPUT_MAPPINGS);
        }
        Path classesJar = environment.getOutputPath("output");
        Path resourcesJar = environment.getOutputPath("resourcesOutput");
        Predicate<String> denyPredicate = s -> false;
        if (!this.denyListPatterns.isEmpty()) {
            denyPredicate = Pattern.compile(this.denyListPatterns.stream().map(Pattern::pattern).collect(Collectors.joining("|"))).asMatchPredicate();
        }
        try (ZipFile jar = new ZipFile(inputJar.toFile());
             BufferedOutputStream classesFileOut = new BufferedOutputStream(Files.newOutputStream(classesJar, new OpenOption[0]));
             BufferedOutputStream resourcesFileOut = new BufferedOutputStream(Files.newOutputStream(resourcesJar, new OpenOption[0]));
             JarOutputStream classesJarOut = new JarOutputStream(classesFileOut);
             JarOutputStream resourcesJarOut = new JarOutputStream(resourcesFileOut);){
            if (this.generateDistManifestSettings != null) {
                SplitResourcesFromClassesAction.generateDistSourceManifest(this.generateDistManifestSettings.distId(), jar, this.generateDistManifestSettings.otherDistId(), otherDistJarPath, mappingsPath, resourcesJarOut);
            }
            Enumeration<? extends ZipEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String filename;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || this.generateDistManifestSettings != null && entry.getName().equals("META-INF/MANIFEST.MF") || denyPredicate.test(filename = entry.getName())) continue;
                JarOutputStream destinationStream = filename.endsWith(".class") ? classesJarOut : resourcesJarOut;
                destinationStream.putNextEntry(entry);
                try (InputStream is = jar.getInputStream(entry);){
                    is.transferTo(destinationStream);
                }
                destinationStream.closeEntry();
            }
        }
    }

    private static void generateDistSourceManifest(String distId, ZipFile jar, String otherDistId, Path otherDistJarPath, @Nullable Path mappingsPath, JarOutputStream resourcesJarOut) throws IOException {
        Set<String> theirFiles;
        IMappingFile mappings = mappingsPath != null ? IMappingFile.load(mappingsPath.toFile()) : null;
        Set<String> ourFiles = SplitResourcesFromClassesAction.getFileIndex(jar);
        ourFiles.remove("META-INF/MANIFEST.MF");
        try (ZipFile otherDistJar = new ZipFile(otherDistJarPath.toFile());){
            theirFiles = SplitResourcesFromClassesAction.getFileIndex(otherDistJar);
        }
        theirFiles.remove("META-INF/MANIFEST.MF");
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().putValue("Minecraft-Dists", distId + " " + otherDistId);
        SplitResourcesFromClassesAction.addSourceDistEntries(ourFiles, theirFiles, distId, mappings, manifest);
        SplitResourcesFromClassesAction.addSourceDistEntries(theirFiles, ourFiles, otherDistId, mappings, manifest);
        ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
        manifestEntry.setTimeLocal(MANIFEST_TIME);
        resourcesJarOut.putNextEntry(manifestEntry);
        manifest.write(resourcesJarOut);
        resourcesJarOut.closeEntry();
    }

    /*
     * WARNING - void declaration
     */
    private static void addSourceDistEntries(Set<String> distFiles, Set<String> otherDistFiles, String dist, IMappingFile mappings, Manifest manifest) {
        for (String string : distFiles) {
            void var6_6;
            if (otherDistFiles.contains(string)) continue;
            Attributes fileAttr = new Attributes(1);
            fileAttr.putValue("Minecraft-Dist", dist);
            if (mappings != null && string.endsWith(".class")) {
                String string2 = mappings.remapClass(string.substring(0, string.length() - ".class".length())) + ".class";
            }
            manifest.getEntries().put((String)var6_6, fileAttr);
        }
    }

    private static Set<String> getFileIndex(ZipFile zipFile) {
        HashSet<String> result = new HashSet<String>(zipFile.size());
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            result.add(entry.getName());
        }
        return result;
    }

    public void addDenyPatterns(String ... patterns) {
        for (String pattern : patterns) {
            this.denyListPatterns.add(Pattern.compile(pattern));
        }
    }

    public void generateSplitManifest(String distId, String otherDistId) {
        this.generateDistManifestSettings = new GenerateDistManifestSettings(Objects.requireNonNull(distId, "distId"), Objects.requireNonNull(otherDistId, "otherDistId"));
    }

    @Override
    public void computeCacheKey(CacheKeyBuilder ck) {
        super.computeCacheKey(ck);
        ck.addStrings("deny patterns", this.denyListPatterns.stream().map(Pattern::pattern).toList());
        if (this.generateDistManifestSettings != null) {
            ck.add("generate dist manifest - our dist", this.generateDistManifestSettings.distId);
            ck.add("generate dist manifest - other dist", this.generateDistManifestSettings.otherDistId);
        }
    }

    private record GenerateDistManifestSettings(String distId, String otherDistId) {
    }
}

