/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.engine;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.zip.ZipFile;
import net.neoforged.neoform.runtime.cache.CacheKey;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.cli.FileHashService;

public final class DataSource {
    private final ZipFile archive;
    private final String folder;
    private final FileHashService fileHashService;

    public DataSource(ZipFile archive, String folder, FileHashService fileHashService) {
        this.archive = archive;
        this.folder = folder;
        this.fileHashService = fileHashService;
    }

    public ZipFile archive() {
        return this.archive;
    }

    public String folder() {
        return this.folder;
    }

    public CacheKey.AnnotatedValue cacheKey() {
        try {
            Path archivePath = Path.of(this.archive.getName(), new String[0]);
            String hash = this.fileHashService.getHashValue(archivePath);
            return new CacheKey.AnnotatedValue(hash, CacheKeyBuilder.prettifyPath(archivePath));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to compute hash for archive " + this.archive.getName(), e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DataSource that = (DataSource)obj;
        return this.archive == that.archive && Objects.equals(this.folder, that.folder);
    }

    public int hashCode() {
        return Objects.hash(this.archive, this.folder);
    }

    public String toString() {
        return this.archive.getName() + "!" + this.folder;
    }
}

