/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.downloads;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HexFormat;
import java.util.List;
import net.neoforged.neoform.runtime.artifacts.ArtifactManager;
import net.neoforged.neoform.runtime.cache.CacheManager;
import net.neoforged.neoform.runtime.cache.LauncherInstallations;
import net.neoforged.neoform.runtime.downloads.AssetDownloadResult;
import net.neoforged.neoform.runtime.downloads.DownloadManager;
import net.neoforged.neoform.runtime.downloads.DownloadSpec;
import net.neoforged.neoform.runtime.downloads.DownloadsFailedException;
import net.neoforged.neoform.runtime.downloads.ParallelDownloader;
import net.neoforged.neoform.runtime.manifests.AssetIndex;
import net.neoforged.neoform.runtime.manifests.AssetIndexReference;
import net.neoforged.neoform.runtime.manifests.AssetObject;
import net.neoforged.neoform.runtime.manifests.MinecraftVersionManifest;
import net.neoforged.neoform.runtime.utils.Logger;
import org.jetbrains.annotations.Nullable;

public class AssetDownloader {
    private static final Logger LOG = Logger.create();
    private static final String INDEX_FOLDER = "indexes";
    private static final String OBJECT_FOLDER = "objects";
    private final DownloadManager downloadManager;
    private final ArtifactManager artifactManager;
    private final LauncherInstallations launcherInstallations;
    private final CacheManager cacheManager;
    @Nullable
    private final Path fixedAssetRoot;

    public AssetDownloader(DownloadManager downloadManager, ArtifactManager artifactManager, LauncherInstallations launcherInstallations, CacheManager cacheManager, @Nullable Path fixedAssetRoot) {
        this.downloadManager = downloadManager;
        this.artifactManager = artifactManager;
        this.launcherInstallations = launcherInstallations;
        this.cacheManager = cacheManager;
        this.fixedAssetRoot = fixedAssetRoot;
    }

    public AssetDownloadResult downloadAssets(String minecraftVersion, URI assetRepository, boolean useLauncherAssetRoot, boolean copyLauncherAssets, int concurrentDownloads) throws IOException, DownloadsFailedException {
        MinecraftVersionManifest versionManifest = MinecraftVersionManifest.from(this.artifactManager.getVersionManifest(minecraftVersion).path());
        AssetIndexReference assetIndexReference = versionManifest.assetIndex();
        LOG.println("Downloading asset index " + assetIndexReference.id());
        Path assetRoot = this.selectAssetRoot(useLauncherAssetRoot, assetIndexReference);
        AssetDownloader.prepareAssetRoot(assetRoot);
        AssetIndex assetIndex = this.acquireAssetIndex(assetRoot, assetIndexReference);
        Path objectsFolder = assetRoot.resolve(OBJECT_FOLDER);
        List<AssetObject> objectsToDownload = assetIndex.objects().values().stream().distinct().filter(obj -> {
            File f = objectsFolder.resolve(obj.getRelativePath()).toFile();
            return f.length() != (long)obj.size() || obj.size() == 0 && !f.exists();
        }).toList();
        try (ParallelDownloader downloader = new ParallelDownloader(this.downloadManager, concurrentDownloads, objectsFolder, objectsToDownload.size());){
            if (copyLauncherAssets) {
                List<Path> objectDirectories = this.launcherInstallations.getAssetRoots().stream().map(d -> d.resolve(OBJECT_FOLDER)).toList();
                downloader.setLocalSources(objectDirectories);
            }
            for (AssetObject object : objectsToDownload) {
                AssetDownloadSpec spec = new AssetDownloadSpec(assetRepository, object);
                String objectHash = object.hash();
                String objectPath = objectHash.substring(0, 2) + "/" + objectHash;
                downloader.submitDownload(spec, objectPath);
            }
        }
        return new AssetDownloadResult(assetRoot, assetIndexReference.id());
    }

    private AssetIndex acquireAssetIndex(Path assetRoot, AssetIndexReference assetIndexReference) throws IOException {
        Path indexFolder = assetRoot.resolve(INDEX_FOLDER);
        Path assetIndexPath = indexFolder.resolve(assetIndexReference.id() + ".json");
        this.downloadManager.download(assetIndexReference, assetIndexPath);
        return AssetIndex.from(assetIndexPath);
    }

    private Path selectAssetRoot(boolean useLauncherAssetRoot, AssetIndexReference assetIndexReference) {
        List<Path> assetRoots;
        if (this.fixedAssetRoot != null) {
            LOG.println("Using fixed asset root: " + String.valueOf(this.fixedAssetRoot));
            return this.fixedAssetRoot;
        }
        Path assetRoot = null;
        if (useLauncherAssetRoot && (assetRoot = this.launcherInstallations.getAssetDirectoryForIndex(assetIndexReference.id())) == null && !(assetRoots = this.launcherInstallations.getAssetRoots()).isEmpty()) {
            assetRoot = assetRoots.getFirst();
        }
        if (assetRoot == null) {
            assetRoot = this.cacheManager.getAssetsDir();
        }
        LOG.println("Using Minecraft asset root: " + String.valueOf(assetRoot));
        return assetRoot;
    }

    private static void prepareAssetRoot(Path assetRoot) throws IOException {
        Path indexFolder = assetRoot.resolve(INDEX_FOLDER);
        Files.createDirectories(indexFolder, new FileAttribute[0]);
        Path objectsFolder = assetRoot.resolve(OBJECT_FOLDER);
        Files.createDirectories(objectsFolder, new FileAttribute[0]);
        for (int i = 0; i < 256; ++i) {
            Path objectSubFolder = objectsFolder.resolve(HexFormat.of().toHexDigits(i, 2));
            Files.createDirectories(objectSubFolder, new FileAttribute[0]);
        }
    }

    private static class AssetDownloadSpec
    implements DownloadSpec {
        private final URI assetsBaseUrl;
        private final AssetObject object;

        public AssetDownloadSpec(URI assetsBaseUrl, AssetObject object) {
            this.assetsBaseUrl = assetsBaseUrl;
            this.object = object;
        }

        @Override
        public URI uri() {
            return URI.create(this.assetsBaseUrl.toString() + this.object.getRelativePath());
        }

        @Override
        public int size() {
            return this.object.size();
        }

        @Override
        @Nullable
        public String checksum() {
            return this.object.hash();
        }

        @Override
        @Nullable
        public String checksumAlgorithm() {
            return "SHA1";
        }
    }
}

