/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.neoforged.neoform.runtime.cache.CacheKey;
import net.neoforged.neoform.runtime.cli.FileHashService;
import org.jetbrains.annotations.Nullable;

public class CacheKeyBuilder {
    private final String type;
    private final FileHashService fileHashService;
    private final Map<String, CacheKey.AnnotatedValue> components = new LinkedHashMap<String, CacheKey.AnnotatedValue>();

    public CacheKeyBuilder(String type, FileHashService fileHashService) {
        this.type = type;
        this.fileHashService = fileHashService;
    }

    public void addPaths(String component, Collection<Path> resultPath) {
        this.add(component, resultPath.parallelStream().map(path -> {
            try {
                return new CacheKey.AnnotatedValue(this.fileHashService.getHashValue((Path)path), path.toString());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).toList());
    }

    public void addPath(String component, Path path) {
        String hashValue;
        try {
            hashValue = this.fileHashService.getHashValue(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.add(component, hashValue, CacheKeyBuilder.prettifyPath(path));
    }

    public static String prettifyPath(Path path) {
        Path userHome = Paths.get(System.getProperty("user.home"), new String[0]);
        Object prettifiedPath = path.startsWith(userHome) ? "~/" + userHome.relativize(path).toString().replace('\\', '/') : path.toString();
        return prettifiedPath;
    }

    public void add(String component, String text) {
        this.add(component, text, null);
    }

    public void add(String component, String text, @Nullable String annotation) {
        if (this.components.containsKey(component)) {
            throw new IllegalArgumentException("Duplicate cache key component: " + component);
        }
        this.components.put(component, new CacheKey.AnnotatedValue(text, annotation));
    }

    public void add(String component, CacheKey.AnnotatedValue value) {
        this.add(component, value.value(), value.annotation());
    }

    public void addStrings(String component, List<String> values) {
        if (this.components.containsKey(component)) {
            throw new IllegalArgumentException("Duplicate cache key component: " + component);
        }
        for (int i = 0; i < values.size(); ++i) {
            this.add(component + "[" + i + "]", values.get(i), null);
        }
    }

    private void add(String component, List<CacheKey.AnnotatedValue> values) {
        if (this.components.containsKey(component)) {
            throw new IllegalArgumentException("Duplicate cache key component: " + component);
        }
        for (int i = 0; i < values.size(); ++i) {
            this.components.put(component + "[" + i + "]", values.get(i));
        }
    }

    public CacheKey build() {
        return new CacheKey(this.type, this.components);
    }

    public FileHashService getFileHashService() {
        return this.fileHashService;
    }
}

