/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cli;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import net.neoforged.neoform.runtime.actions.ApplySourceTransformAction;
import net.neoforged.neoform.runtime.actions.ExternalJavaToolAction;
import net.neoforged.neoform.runtime.actions.InjectFromZipFileSource;
import net.neoforged.neoform.runtime.actions.InjectZipContentAction;
import net.neoforged.neoform.runtime.actions.MergeWithSourcesAction;
import net.neoforged.neoform.runtime.actions.PatchActionFactory;
import net.neoforged.neoform.runtime.actions.RecompileSourcesAction;
import net.neoforged.neoform.runtime.actions.StripManifestDigestContentFilter;
import net.neoforged.neoform.runtime.artifacts.Artifact;
import net.neoforged.neoform.runtime.artifacts.ArtifactManager;
import net.neoforged.neoform.runtime.artifacts.ClasspathItem;
import net.neoforged.neoform.runtime.cli.NeoFormEngineCommand;
import net.neoforged.neoform.runtime.config.neoforge.NeoForgeConfig;
import net.neoforged.neoform.runtime.engine.DataSource;
import net.neoforged.neoform.runtime.engine.NeoFormEngine;
import net.neoforged.neoform.runtime.graph.ExecutionGraph;
import net.neoforged.neoform.runtime.graph.ExecutionNode;
import net.neoforged.neoform.runtime.graph.ExecutionNodeBuilder;
import net.neoforged.neoform.runtime.graph.NodeOutput;
import net.neoforged.neoform.runtime.graph.NodeOutputType;
import net.neoforged.neoform.runtime.graph.transforms.GraphTransform;
import net.neoforged.neoform.runtime.graph.transforms.ModifyAction;
import net.neoforged.neoform.runtime.graph.transforms.ReplaceNodeOutput;
import net.neoforged.neoform.runtime.utils.FileUtil;
import net.neoforged.neoform.runtime.utils.HashingUtil;
import net.neoforged.neoform.runtime.utils.Logger;
import net.neoforged.neoform.runtime.utils.ToolCoordinate;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Run the NeoForm engine and produce Minecraft artifacts"})
public class RunNeoFormCommand
extends NeoFormEngineCommand {
    private static final Logger LOG = Logger.create();
    @CommandLine.ArgGroup(exclusive=false, multiplicity="1")
    SourceArtifacts sourceArtifacts;
    @CommandLine.Option(names={"--dist"}, required=true)
    String dist;
    @CommandLine.Option(names={"--write-result"}, arity="*")
    List<String> writeResults = new ArrayList<String>();
    @CommandLine.Option(names={"--access-transformer"}, arity="*", description={"path to an access transformer file, which widens the access modifiers of classes/methods/fields"})
    List<String> additionalAccessTransformers = new ArrayList<String>();
    @CommandLine.Option(names={"--validated-access-transformer"}, arity="*", description={"same as --access-transformer, but files added using this option will fail the build if they contain targets that do not exist."})
    List<String> validatedAccessTransformers = new ArrayList<String>();
    @CommandLine.Option(names={"--interface-injection-data"}, arity="*", description={"path to an interface injection data file, which extends classes with implements/extends clauses."})
    List<Path> interfaceInjectionDataFiles = new ArrayList<Path>();
    @Deprecated
    @CommandLine.Option(names={"--validate-access-transformers"}, description={"[DEPRECATED] Use --validated-access-transformer instead"})
    boolean validateAccessTransformers;
    @CommandLine.Option(names={"--parchment-data"}, description={"Path or Maven coordinates of parchment data to use"})
    String parchmentData;
    @CommandLine.Option(names={"--parchment-conflict-prefix"}, description={"Setting this option enables automatic Parchment parameter conflict resolution and uses this prefix for parameter names that clash."})
    String parchmentConflictPrefix;

    @Override
    protected void runWithNeoFormEngine(NeoFormEngine engine, List<AutoCloseable> closables) throws IOException, InterruptedException {
        ArtifactManager artifactManager = engine.getArtifactManager();
        if (this.sourceArtifacts.neoforge != null) {
            List<String> sasFiles;
            Path neoformArtifact;
            Artifact neoforgeArtifact = artifactManager.get(this.sourceArtifacts.neoforge);
            JarFile neoforgeZipFile = engine.addManagedResource(new JarFile(neoforgeArtifact.path().toFile()));
            NeoForgeConfig neoforgeConfig = NeoForgeConfig.from(neoforgeZipFile);
            if (this.sourceArtifacts.neoform != null) {
                LOG.println("Overriding NeoForm version " + neoforgeConfig.neoformArtifact() + " with CLI argument " + this.sourceArtifacts.neoform);
                neoformArtifact = artifactManager.get(this.sourceArtifacts.neoform).path();
            } else {
                neoformArtifact = artifactManager.get(neoforgeConfig.neoformArtifact()).path();
            }
            engine.loadNeoFormData(neoformArtifact, this.dist);
            engine.addDataSource("neoForgeAccessTransformers", neoforgeZipFile, neoforgeConfig.accessTransformersFolder());
            ArrayList<GraphTransform> transforms = new ArrayList<GraphTransform>();
            Path neoforgeSources = artifactManager.get(neoforgeConfig.sourcesArtifact()).path();
            Path neoforgeClasses = artifactManager.get(neoforgeConfig.universalArtifact()).path();
            ZipFile neoforgeSourcesZip = new ZipFile(neoforgeSources.toFile());
            ZipFile neoforgeClassesZip = new ZipFile(neoforgeClasses.toFile());
            engine.addManagedResource(neoforgeSourcesZip);
            engine.addManagedResource(neoforgeClassesZip);
            ApplySourceTransformAction transformSources2 = RunNeoFormCommand.getOrAddTransformSourcesAction(engine);
            transformSources2.setAccessTransformersData(List.of("neoForgeAccessTransformers"));
            if (engine.getProcessGeneration().sourcesUseIntermediaryNames()) {
                engine.applyTransforms(List.of(new ModifyAction<InjectZipContentAction>("inject", InjectZipContentAction.class, action -> {
                    action.getInjectedSources().add(new InjectFromZipFileSource(neoforgeClassesZip, "/", Pattern.compile("^(?!META-INF/[^/]+\\.(SF|RSA|DSA|EC)$|.*\\.class$).*"), StripManifestDigestContentFilter.INSTANCE));
                    action.getInjectedSources().add(new InjectFromZipFileSource(neoforgeSourcesZip, "/", Pattern.compile("^(?!META-INF/MANIFEST.MF$).*")));
                })));
            }
            transforms.add(new ModifyAction<RecompileSourcesAction>("recompile", RecompileSourcesAction.class, action -> {
                action.getClasspath().addMavenLibraries(neoforgeConfig.libraries());
                action.getClasspath().addPaths(List.of(neoforgeClasses));
            }));
            if (engine.getProcessGeneration().supportsSideAnnotationStripping() && !(sasFiles = neoforgeConfig.sideAnnotationStrippers()).isEmpty()) {
                for (int i = 0; i < sasFiles.size(); ++i) {
                    engine.addDataSource("sasFile" + i, neoforgeZipFile, sasFiles.get(i));
                }
                transforms.add(new ReplaceNodeOutput("rename", "output", "stripSideAnnotations", (builder, previousOutput) -> {
                    builder.input("input", previousOutput.asInput());
                    ExternalJavaToolAction action = new ExternalJavaToolAction(ToolCoordinate.MCF_SIDE_ANNOTATION_STRIPPER);
                    ArrayList<String> args = new ArrayList<String>();
                    Collections.addAll(args, "--strip", "--input", "{input}", "--output", "{output}");
                    for (int i = 0; i < sasFiles.size(); ++i) {
                        args.add("--data");
                        args.add("{sasFile" + i + "}");
                    }
                    action.setArgs(args);
                    builder.action(action);
                    return builder.output("output", NodeOutputType.JAR, "The jar file with the desired side annotations removed");
                }));
            }
            transforms.add(new ReplaceNodeOutput("patch", "output", "applyNeoforgePatches", (builder, previousOutput) -> PatchActionFactory.makeAction(builder, new DataSource(neoforgeZipFile, neoforgeConfig.patchesFolder(), engine.getFileHashingService()), previousOutput, Objects.requireNonNullElse(neoforgeConfig.basePathPrefix(), "a/"), Objects.requireNonNullElse(neoforgeConfig.modifiedPathPrefix(), "b/"))));
            engine.applyTransforms(transforms);
            NodeOutput sourcesWithNeoForgeOutput = RunNeoFormCommand.createSourcesWithNeoForge(engine, neoforgeSourcesZip);
            NodeOutput compiledWithNeoForgeOutput = RunNeoFormCommand.createCompiledWithNeoForge(engine, neoforgeClassesZip);
            RunNeoFormCommand.createSourcesAndCompiledWithNeoForge(engine.getGraph(), compiledWithNeoForgeOutput, sourcesWithNeoForgeOutput);
        } else {
            Path neoFormDataPath = artifactManager.get(this.sourceArtifacts.neoform).path();
            engine.loadNeoFormData(neoFormDataPath, this.dist);
        }
        this.applyAdditionalAccessTransformers(engine);
        if (this.parchmentData != null) {
            Artifact parchmentDataFile = artifactManager.get(this.parchmentData);
            Consumer<ApplySourceTransformAction> jstConsumer = transformSources -> {
                transformSources.setParchmentData(parchmentDataFile.path());
                if (this.parchmentConflictPrefix != null) {
                    transformSources.addArg("--parchment-conflict-prefix=" + this.parchmentConflictPrefix);
                }
            };
            if (engine.getProcessGeneration().sourcesUseIntermediaryNames()) {
                engine.applyTransform(new ReplaceNodeOutput("remapSrgSourcesToOfficial", "output", "applyParchment", RunNeoFormCommand.sourceTransform(engine, jstConsumer)));
            } else {
                jstConsumer.accept(RunNeoFormCommand.getOrAddTransformSourcesAction(engine));
            }
        }
        if (!this.interfaceInjectionDataFiles.isEmpty()) {
            ExecutionNode transformNode = RunNeoFormCommand.getOrAddTransformSourcesNode(engine);
            ((ApplySourceTransformAction)transformNode.action()).setInjectedInterfaces(this.interfaceInjectionDataFiles);
            engine.applyTransform(new ModifyAction<RecompileSourcesAction>("recompile", RecompileSourcesAction.class, action -> action.getSourcepath().add(ClasspathItem.of(transformNode.getRequiredOutput("stubs")))));
        }
        this.execute(engine);
    }

    private void applyAdditionalAccessTransformers(NeoFormEngine engine) {
        if (!this.additionalAccessTransformers.isEmpty() || !this.validatedAccessTransformers.isEmpty()) {
            ApplySourceTransformAction transformSources = RunNeoFormCommand.getOrAddTransformSourcesAction(engine);
            transformSources.setAdditionalAccessTransformers(this.additionalAccessTransformers.stream().map(x$0 -> Paths.get(x$0, new String[0])).toList());
            transformSources.setValidatedAccessTransformers(this.validatedAccessTransformers.stream().map(x$0 -> Paths.get(x$0, new String[0])).toList());
            if (this.validateAccessTransformers) {
                transformSources.addArg("--access-transformer-validation=error");
            }
        }
    }

    private static NodeOutput createCompiledWithNeoForge(NeoFormEngine engine, ZipFile neoforgeClassesZip) {
        ExecutionGraph graph = engine.getGraph();
        NodeOutput recompiledClasses = graph.getRequiredOutput("recompile", "output");
        if (engine.getProcessGeneration().sourcesUseIntermediaryNames()) {
            graph.setResult("compiledWithNeoForge", recompiledClasses);
            return recompiledClasses;
        }
        ExecutionNodeBuilder builder = graph.nodeBuilder("compiledWithNeoForge");
        builder.input("input", recompiledClasses.asInput());
        NodeOutput output = builder.output("output", NodeOutputType.JAR, "JAR containing NeoForge classes, resources and Minecraft classes");
        builder.action(new InjectZipContentAction(List.of(new InjectFromZipFileSource(neoforgeClassesZip, "/"))));
        builder.build();
        graph.setResult("compiledWithNeoForge", output);
        return output;
    }

    private static NodeOutput createSourcesWithNeoForge(NeoFormEngine engine, ZipFile neoforgeSourcesZip) {
        ExecutionGraph graph = engine.getGraph();
        if (engine.getProcessGeneration().sourcesUseIntermediaryNames()) {
            NodeOutput remapSrgSourcesToOfficialOutput = graph.getRequiredOutput("remapSrgSourcesToOfficial", "output");
            graph.setResult("sourcesWithNeoForge", remapSrgSourcesToOfficialOutput);
            return remapSrgSourcesToOfficialOutput;
        }
        NodeOutput transformedSourceOutput = graph.getRequiredOutput("transformSources", "output");
        ExecutionNodeBuilder builder = graph.nodeBuilder("sourcesWithNeoForge");
        builder.input("input", transformedSourceOutput.asInput());
        NodeOutput output = builder.output("output", NodeOutputType.ZIP, "Source ZIP containing NeoForge and Minecraft sources");
        builder.action(new InjectZipContentAction(List.of(new InjectFromZipFileSource(neoforgeSourcesZip, "/"))));
        builder.build();
        graph.setResult("sourcesWithNeoForge", output);
        return output;
    }

    private static void createSourcesAndCompiledWithNeoForge(ExecutionGraph graph, NodeOutput compiledWithNeoForgeOutput, NodeOutput sourcesWithNeoForgeOutput) {
        ExecutionNodeBuilder builder = graph.nodeBuilder("sourcesAndCompiledWithNeoForge");
        builder.input("classes", compiledWithNeoForgeOutput.asInput());
        builder.input("sources", sourcesWithNeoForgeOutput.asInput());
        NodeOutput output = builder.output("output", NodeOutputType.JAR, "Combined output of sourcesWithNeoForge and compiledWithNeoForge");
        builder.action(new MergeWithSourcesAction());
        builder.build();
        graph.setResult("sourcesAndCompiledWithNeoForge", output);
    }

    private void execute(NeoFormEngine engine) throws InterruptedException, IOException {
        Map<String, Path> neededResults;
        if (this.printGraph) {
            StringWriter stringWriter = new StringWriter();
            engine.dumpGraph(new PrintWriter(stringWriter));
            LOG.println(stringWriter.toString());
        }
        if ((neededResults = this.writeResults.stream().map(encodedResult -> {
            String[] parts = encodedResult.split(":", 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException("Specify a result destination in the form: <resultid>:<destination>");
            }
            return parts;
        }).collect(Collectors.toMap(parts -> parts[0], parts -> Paths.get(parts[1], new String[0])))).isEmpty()) {
            System.err.println("No results requested. Available results: " + String.valueOf(engine.getAvailableResults()));
            System.exit(1);
        }
        Map<String, Path> results = engine.createResults(neededResults.keySet().toArray(new String[0]));
        for (Map.Entry<String, Path> entry : neededResults.entrySet()) {
            Path result = results.get(entry.getKey());
            if (result == null) {
                throw new IllegalStateException("Result " + entry.getKey() + " was requested but not produced");
            }
            String resultFileHash = HashingUtil.hashFile(result, "SHA-1");
            try {
                if (HashingUtil.hashFile(entry.getValue(), "SHA-1").equals(resultFileHash)) {
                    continue;
                }
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
            Path tmpFile = Paths.get(String.valueOf(entry.getValue()) + ".tmp", new String[0]);
            Files.copy(result, tmpFile, StandardCopyOption.REPLACE_EXISTING);
            FileUtil.atomicMove(tmpFile, entry.getValue());
        }
    }

    private static ApplySourceTransformAction getOrAddTransformSourcesAction(NeoFormEngine engine) {
        return (ApplySourceTransformAction)RunNeoFormCommand.getOrAddTransformSourcesNode(engine).action();
    }

    private static ExecutionNode getOrAddTransformSourcesNode(NeoFormEngine engine) {
        ExecutionGraph graph = engine.getGraph();
        ExecutionNode transformNode = graph.getNode("transformSources");
        if (transformNode != null) {
            if (transformNode.action() instanceof ApplySourceTransformAction) {
                return transformNode;
            }
            throw new IllegalStateException("Node transformSources has a different action type than expected. Expected: " + String.valueOf(ApplySourceTransformAction.class) + " but got " + String.valueOf(transformNode.action().getClass()));
        }
        new ReplaceNodeOutput("patch", "output", "transformSources", RunNeoFormCommand.sourceTransform(engine, applySourceTransformAction -> {})).apply(engine, graph);
        return RunNeoFormCommand.getOrAddTransformSourcesNode(engine);
    }

    private static ReplaceNodeOutput.NodeFactory sourceTransform(NeoFormEngine engine, Consumer<ApplySourceTransformAction> actionConsumer) {
        return (builder, previousNodeOutput) -> {
            builder.input("input", previousNodeOutput.asInput());
            builder.inputFromNodeOutput("versionManifest", "downloadJson", "output");
            ApplySourceTransformAction action = new ApplySourceTransformAction();
            ExternalJavaToolAction renameAction = (ExternalJavaToolAction)engine.getGraph().getNode("rename").action();
            action.getListLibraries().setClasspath(renameAction.getListLibraries().getClasspath().copy());
            builder.action(action);
            actionConsumer.accept(action);
            builder.output("stubs", NodeOutputType.JAR, "Additional stubs (resulted as part of interface injection) to add to the recompilation classpath");
            return builder.output("output", NodeOutputType.ZIP, "Sources with additional transforms (ATs, Parchment, Interface Injections) applied");
        };
    }

    static class SourceArtifacts {
        @CommandLine.Option(names={"--neoform"})
        String neoform;
        @CommandLine.Option(names={"--neoforge"})
        String neoforge;

        SourceArtifacts() {
        }
    }
}

