/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.config.neoform;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.neoforged.neoform.runtime.config.neoform.NeoFormConfig;
import net.neoforged.neoform.runtime.config.neoform.NeoFormFunction;
import net.neoforged.neoform.runtime.config.neoform.NeoFormStep;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;
import org.jetbrains.annotations.Nullable;

public class NeoFormDistConfig {
    private final NeoFormConfig config;
    private final String dist;

    public NeoFormDistConfig(NeoFormConfig config, String dist) {
        this.config = config;
        this.dist = dist;
    }

    public String dist() {
        return this.dist;
    }

    public int javaVersion() {
        return this.config.javaVersion();
    }

    public String minecraftVersion() {
        return this.config.minecraftVersion();
    }

    public List<NeoFormStep> steps() {
        return Objects.requireNonNull(this.config.steps().get(this.dist));
    }

    @Nullable
    public NeoFormFunction getFunction(String id) {
        return this.config.functions().get(id);
    }

    public boolean hasData(String id) {
        return this.config.data().containsKey(id);
    }

    public String getDataPathInZip(String id) {
        return this.config.getDataPathInZip(id, this.dist);
    }

    public Map<String, String> getData() {
        HashMap<String, String> result = new HashMap<String, String>(this.config.data().size());
        for (Map.Entry<String, Object> entry : this.config.data().entrySet()) {
            String value;
            if (entry.getValue() instanceof String) {
                value = (String)entry.getValue();
            } else {
                Object object = entry.getValue();
                if (object instanceof Map) {
                    Map dataMap = (Map)object;
                    Object distSpecificData = dataMap.get(this.dist);
                    if (distSpecificData == null) {
                        throw new IllegalArgumentException("There's no data for " + entry.getKey() + " and distribution " + this.dist);
                    }
                    if (!(distSpecificData instanceof String)) {
                        throw new IllegalArgumentException("Data for " + entry.getKey() + " and distribution " + this.dist + " is not a String: " + String.valueOf(distSpecificData));
                    }
                    value = (String)distSpecificData;
                } else {
                    throw new IllegalArgumentException("Unexpected type for data entry " + entry.getKey() + ": " + String.valueOf(entry.getValue()));
                }
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }

    public List<MavenCoordinate> libraries() {
        return this.config.libraries().getOrDefault(this.dist, List.of());
    }
}

