/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.neoforged.neoform.runtime.graph.ExecutionGraph;
import net.neoforged.neoform.runtime.graph.ExecutionNode;

final class TopologicalSort {
    private TopologicalSort() {
    }

    public static List<ExecutionNode> topologicalSort(ExecutionGraph graph) throws IllegalArgumentException {
        ArrayDeque<ExecutionNode> queue = new ArrayDeque<ExecutionNode>();
        HashMap<ExecutionNode, Integer> degrees = new HashMap<ExecutionNode, Integer>();
        ArrayList<ExecutionNode> results = new ArrayList<ExecutionNode>();
        IdentityHashMap<ExecutionNode, Set> successors = new IdentityHashMap<ExecutionNode, Set>();
        for (ExecutionNode node2 : graph.getNodes()) {
            successors.putIfAbsent(node2, Collections.newSetFromMap(new IdentityHashMap()));
            for (ExecutionNode predecessor : node2.getPredecessors()) {
                successors.computeIfAbsent(predecessor, ignored -> Collections.newSetFromMap(new IdentityHashMap())).add(node2);
            }
        }
        for (ExecutionNode node2 : graph.getNodes()) {
            int degree2 = node2.getPredecessors().size();
            if (degree2 == 0) {
                queue.add(node2);
                continue;
            }
            degrees.put(node2, degree2);
        }
        while (!queue.isEmpty()) {
            ExecutionNode current = (ExecutionNode)queue.remove();
            results.add(current);
            for (ExecutionNode successor : (Set)successors.get(current)) {
                int updated = degrees.compute(successor, (node, degree) -> Objects.requireNonNull(degree, () -> "Invalid degree present for " + String.valueOf(node)) - 1);
                if (updated != 0) continue;
                queue.add(successor);
                degrees.remove(successor);
            }
        }
        if (!degrees.isEmpty()) {
            throw new IllegalStateException("The graph has cycles");
        }
        return results;
    }
}

