/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cache;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.neoforged.neoform.runtime.utils.HashingUtil;
import org.jetbrains.annotations.Nullable;

public record CacheKey(String type, String hashValue, Map<String, AnnotatedValue> components) {
    public static final String TYPE_REGEX = "[a-zA-Z0-9]{1,32}";
    public static final Pattern TYPE_PATTERN = Pattern.compile("[a-zA-Z0-9]{1,32}");
    public static final String HASH_VALUE_REGEX = "[0-9a-f]{40}";
    public static final Pattern HASH_VALUE_PATTERN = Pattern.compile("[0-9a-f]{40}");
    public static final Pattern FILENAME_PREFIX_PATTERN = Pattern.compile("^([a-zA-Z0-9]{1,32}_[0-9a-f]{40})");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public CacheKey {
        if (!TYPE_PATTERN.matcher(type).matches()) {
            throw new IllegalArgumentException("Invalid type: " + type + ". Must conform to regular expression [a-zA-Z0-9]{1,32}");
        }
        if (!HASH_VALUE_PATTERN.matcher(hashValue).matches()) {
            throw new IllegalArgumentException("Invalid hash value: " + type + ". Must be a lower-case SHA1 hash");
        }
    }

    public CacheKey(String type, Map<String, AnnotatedValue> components) {
        this(type, CacheKey.computeHashValue(components), components);
    }

    public List<Delta> getDiff(CacheKey other) {
        ArrayList<Delta> deltas = new ArrayList<Delta>();
        for (Map.Entry<String, AnnotatedValue> entry : this.components.entrySet()) {
            AnnotatedValue ourValue = entry.getValue();
            AnnotatedValue theirValue = other.components().get(entry.getKey());
            if (theirValue != null && ourValue.value().equals(theirValue.value())) continue;
            deltas.add(new Delta(entry.getKey(), ourValue, theirValue));
        }
        for (Map.Entry<String, AnnotatedValue> entry : other.components.entrySet()) {
            if (this.components.containsKey(entry.getKey())) continue;
            deltas.add(new Delta(entry.getKey(), null, entry.getValue()));
        }
        return deltas;
    }

    private static String computeHashValue(Map<String, AnnotatedValue> components) {
        String hashValue = components.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + ": " + ((AnnotatedValue)entry.getValue()).value()).collect(Collectors.joining("\n"));
        return HashingUtil.sha1(hashValue);
    }

    public String describe() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, AnnotatedValue> entry : this.components.entrySet()) {
            result.append(entry.getKey()).append(": ").append(entry.getValue().value());
            if (entry.getValue().annotation != null) {
                result.append(" (").append(entry.getValue().annotation).append(")");
            }
            result.append("\n");
        }
        return result.toString();
    }

    public void write(Path path) throws IOException {
        Files.writeString(path, (CharSequence)GSON.toJson(this), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static CacheKey read(Path path) throws IOException {
        return GSON.fromJson(Files.readString(path, StandardCharsets.UTF_8), CacheKey.class);
    }

    @Override
    public String toString() {
        return this.type + "_" + this.hashValue;
    }

    public record AnnotatedValue(String value, @Nullable String annotation) {
        @Override
        public String toString() {
            if (this.annotation == null) {
                return this.value;
            }
            return this.value + " (" + this.annotation + ")";
        }
    }

    public record Delta(String key, @Nullable AnnotatedValue ours, @Nullable AnnotatedValue theirs) {
    }
}

