/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.utils;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;

public final class StringUtil {
    private static final String[] FILE_SIZE_SUFFIXES = new String[]{"B", "KiB", "MiB", "GiB", "TiB"};

    private StringUtil() {
    }

    public static String capitalize(String text) {
        return Character.toUpperCase(text.charAt(0)) + text.substring(1);
    }

    public static String indent(String text, int indent) {
        String indentText = " ".repeat(indent);
        return Arrays.stream(text.split("\n")).map(line -> indentText + line).collect(Collectors.joining("\n"));
    }

    public static String formatBytes(long size) {
        long prevSize = size * 1024L;
        for (String fileSizeSuffix : FILE_SIZE_SUFFIXES) {
            if (size < 10L) {
                DecimalFormat df = new DecimalFormat("###.#", new DecimalFormatSymbols(Locale.ROOT));
                df.setMinimumFractionDigits(0);
                df.setMaximumFractionDigits(1);
                df.setRoundingMode(RoundingMode.DOWN);
                return df.format((double)prevSize / 1024.0) + " " + fileSizeSuffix;
            }
            if (size < 1000L) {
                return size + " " + fileSizeSuffix;
            }
            prevSize = size;
            size /= 1024L;
        }
        return size * 1024L + " " + FILE_SIZE_SUFFIXES[FILE_SIZE_SUFFIXES.length - 1];
    }

    public static String formatDuration(Duration duration) {
        StringBuilder result = new StringBuilder();
        if (duration.toDaysPart() > 0L) {
            result.append(duration.toDaysPart()).append('d');
        }
        if (duration.toHoursPart() > 0) {
            if (!result.isEmpty()) {
                result.append(' ');
            }
            result.append(duration.toHoursPart()).append('h');
        }
        if (duration.toMinutesPart() > 0) {
            if (!result.isEmpty()) {
                result.append(' ');
            }
            result.append(duration.toMinutesPart()).append('m');
        }
        if (duration.toSecondsPart() > 0) {
            if (!result.isEmpty()) {
                result.append(' ');
            }
            result.append(duration.toSecondsPart()).append('s');
        }
        return result.toString();
    }
}

