/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.utils;

import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class FilenameUtil {
    private FilenameUtil() {
    }

    public static String getExtension(String path) {
        int lastSep = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        int potentialExtension = path.lastIndexOf(46);
        if (potentialExtension > lastSep) {
            int doubleExtensionStart = path.lastIndexOf(46, potentialExtension - 1);
            if (doubleExtensionStart > lastSep && potentialExtension - doubleExtensionStart <= 4) {
                return path.substring(doubleExtensionStart);
            }
            return path.substring(potentialExtension);
        }
        return "";
    }

    public static String sanitizeForFilename(String text) {
        return text.replaceAll("[^a-zA-Z0-9._\\-,+'()\"!]+", "_");
    }

    @Nullable
    public static String longestCommonDirPrefix(List<String> paths) {
        int maxLength = paths.stream().mapToInt(s -> s.lastIndexOf(47)).min().orElse(-1);
        if (maxLength == -1) {
            return null;
        }
        String firstFile = paths.getFirst();
        for (int i = maxLength; i >= 1; --i) {
            if (firstFile.charAt(i) != '/') continue;
            for (int j = 0; j < i; ++j) {
                char ch = firstFile.charAt(j);
                boolean allMatch = true;
                for (int k = 1; k < paths.size(); ++k) {
                    if (paths.get(k).charAt(j) == ch) continue;
                    allMatch = false;
                    break;
                }
                if (!allMatch) continue;
                return firstFile.substring(0, i);
            }
        }
        return null;
    }
}

