/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.manifests;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.neoforged.neoform.runtime.manifests.MinecraftDownload;
import net.neoforged.neoform.runtime.manifests.Rule;
import net.neoforged.neoform.runtime.manifests.RuleAction;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;
import net.neoforged.neoform.runtime.utils.OsType;
import org.jetbrains.annotations.Nullable;

public record MinecraftLibrary(@SerializedName(value="name") String artifactId, Downloads downloads, List<Rule> rules, @Nullable Map<OsType, String> natives) {
    public MinecraftLibrary(String artifactId, Downloads downloads, List<Rule> rules, @Nullable Map<OsType, String> natives) {
        Objects.requireNonNull(artifactId, "name");
        rules = Objects.requireNonNullElseGet(rules, List::of);
    }

    public boolean rulesMatch() {
        if (this.rules.isEmpty()) {
            return true;
        }
        for (Rule rule : this.rules) {
            boolean ruleApplies = rule.evaluate();
            if (!ruleApplies && rule.action() == RuleAction.ALLOWED) {
                return false;
            }
            if (!ruleApplies || rule.action() != RuleAction.DISALLOWED) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public MinecraftDownload getArtifactDownload() {
        String classifier;
        if (this.downloads == null) {
            return null;
        }
        if (this.natives != null && (classifier = this.natives.get((Object)OsType.current())) != null) {
            MinecraftDownload download = this.downloads.classifiers.get(classifier);
            if (download == null) {
                throw new IllegalStateException("Download for " + this.artifactId + " references classifier " + classifier + " for natives for OS " + String.valueOf((Object)OsType.current()) + " but it doesn't exist.");
            }
            return download;
        }
        return this.downloads.artifact;
    }

    public MavenCoordinate getMavenCoordinate() {
        String classifier;
        MavenCoordinate coordinate = MavenCoordinate.parse(this.artifactId);
        if (this.natives != null && (classifier = this.natives.get((Object)OsType.current())) != null) {
            coordinate = coordinate.withClassifier(classifier);
        }
        return coordinate;
    }

    @Override
    public String toString() {
        return this.artifactId;
    }

    public record Downloads(MinecraftDownload artifact, Map<String, MinecraftDownload> classifiers) {
        public Downloads {
            if (classifiers == null) {
                classifiers = Map.of();
            }
        }
    }
}

