/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.graph.transforms;

import java.util.function.Consumer;
import java.util.function.Function;
import net.neoforged.neoform.runtime.engine.NeoFormEngine;
import net.neoforged.neoform.runtime.graph.ExecutionGraph;
import net.neoforged.neoform.runtime.graph.ExecutionNode;
import net.neoforged.neoform.runtime.graph.ExecutionNodeAction;
import net.neoforged.neoform.runtime.graph.transforms.GraphTransform;

public class ModifyAction<T extends ExecutionNodeAction>
extends GraphTransform {
    private final String nodeId;
    private final Class<T> expectedActionType;
    private final Function<T, ExecutionNodeAction> actionTransform;

    public ModifyAction(String nodeId, Class<T> expectedActionType, Consumer<T> actionTransform) {
        this(nodeId, expectedActionType, (T action) -> {
            actionTransform.accept(action);
            return action;
        });
    }

    public ModifyAction(String nodeId, Class<T> expectedActionType, Function<T, ExecutionNodeAction> actionTransform) {
        this.nodeId = nodeId;
        this.expectedActionType = expectedActionType;
        this.actionTransform = actionTransform;
    }

    @Override
    public void apply(NeoFormEngine engine, ExecutionGraph graph) {
        ExecutionNode node = graph.getNode(this.nodeId);
        if (node == null) {
            throw new IllegalStateException("Trying to customize node " + this.nodeId + " but it does not exist.");
        }
        if (!this.expectedActionType.isInstance(node.action())) {
            throw new IllegalStateException("Expected node " + this.nodeId + " to have an action of type " + String.valueOf(this.expectedActionType) + ", but it has: " + node.action().getClass().getName());
        }
        ExecutionNodeAction nodeAction = (ExecutionNodeAction)this.expectedActionType.cast(node.action());
        node.setAction(this.actionTransform.apply(nodeAction));
    }
}

