/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.graph;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.neoform.runtime.graph.ExecutionNode;
import net.neoforged.neoform.runtime.graph.ExecutionNodeBuilder;
import net.neoforged.neoform.runtime.graph.NodeInput;
import net.neoforged.neoform.runtime.graph.NodeOutput;
import net.neoforged.neoform.runtime.graph.TopologicalSort;
import net.neoforged.neoform.runtime.utils.StringUtil;
import org.jetbrains.annotations.Nullable;

public class ExecutionGraph {
    private final Map<String, ExecutionNode> nodes = new LinkedHashMap<String, ExecutionNode>();
    private final Map<String, NodeOutput> nodeOutputs = new HashMap<String, NodeOutput>();
    private final Map<String, NodeOutput> results = new HashMap<String, NodeOutput>();
    private static final Pattern DEBUG_OUTPUT_PATTERN = Pattern.compile("^node\\.([a-zA-Z0-9]+)\\.output\\.([a-zA-Z0-9]+)$");

    public ExecutionNodeBuilder nodeBuilder(String id) {
        return new ExecutionNodeBuilder(this, id);
    }

    public void add(ExecutionNode node) {
        if (this.nodes.containsKey(node.toString())) {
            throw new IllegalArgumentException("Duplicate node id: " + node.id());
        }
        for (String string : node.outputs().keySet()) {
            String globalOutputId = ExecutionGraph.getGlobalNodeOutputId(node, string);
            NodeOutput existingOutput = this.nodeOutputs.get(globalOutputId);
            if (existingOutput == null) continue;
            throw new IllegalArgumentException("Output id: " + string + " clashes with " + String.valueOf(existingOutput));
        }
        this.nodes.put(node.id(), node);
        for (Map.Entry entry : node.outputs().entrySet()) {
            this.nodeOutputs.put(ExecutionGraph.getGlobalNodeOutputId(node, (String)entry.getKey()), (NodeOutput)entry.getValue());
        }
    }

    public void setResult(String id, NodeOutput output) {
        this.results.put(id, output);
    }

    public NodeOutput getResult(String id) {
        NodeOutput output = this.results.get(id);
        if (output != null) {
            return output;
        }
        Matcher matcher = DEBUG_OUTPUT_PATTERN.matcher(id);
        if (matcher.matches()) {
            String step = matcher.group(1);
            String outputId = matcher.group(2);
            return this.getRequiredOutput(step, outputId);
        }
        return null;
    }

    public Map<String, NodeOutput> getResults() {
        return this.results;
    }

    public NodeOutput getRequiredOutput(String nodeId, String outputId) {
        ExecutionNode node = this.getNode(nodeId);
        if (node == null) {
            throw new IllegalArgumentException("Node not found: " + nodeId);
        }
        NodeOutput output = node.outputs().get(outputId);
        if (output == null) {
            throw new IllegalArgumentException("Output " + outputId + " not found on node " + nodeId);
        }
        return output;
    }

    @Nullable
    public NodeOutput getOutput(String globalOutputId) {
        return this.nodeOutputs.get(globalOutputId);
    }

    private static String getGlobalNodeOutputId(ExecutionNode node, String outputId) {
        return node.id() + StringUtil.capitalize(outputId);
    }

    @Nullable
    public ExecutionNode getNode(String nodeId) {
        return this.nodes.get(nodeId);
    }

    public boolean hasOutput(String nodeId, String outputId) {
        ExecutionNode node = this.getNode(nodeId);
        return node != null && node.hasOutput(outputId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter writer) {
        try {
            List<ExecutionNode> sortedNodes = TopologicalSort.topologicalSort(this);
            writer.println("%%{init: {\"flowchart\": {\"htmlLabels\": false}} }%%");
            writer.println("flowchart LR");
            for (ExecutionNode executionNode : sortedNodes) {
                writer.println("  " + executionNode.id() + "[[" + executionNode.id() + "]]");
                for (NodeInput input : executionNode.inputs().values()) {
                    for (ExecutionNode inputNode : input.getNodeDependencies()) {
                        writer.println("  " + inputNode.id() + "-->|" + input.getId() + "|" + executionNode.id());
                    }
                }
            }
            for (Map.Entry entry : this.results.entrySet()) {
                writer.println("  result-" + (String)entry.getKey() + "(\"`**Result**\n" + (String)entry.getKey() + "`\")");
                writer.println("  " + ((NodeOutput)entry.getValue()).getNode().id() + " --o result-" + (String)entry.getKey());
            }
        }
        finally {
            writer.flush();
        }
    }

    public Collection<ExecutionNode> getNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }
}

