/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.neoforged.neoform.runtime.actions.BuiltInAction;
import net.neoforged.neoform.runtime.actions.CreateLegacyMappingsAction;
import net.neoforged.neoform.runtime.actions.CreateLibrariesOptionsFileAction;
import net.neoforged.neoform.runtime.actions.DownloadFromVersionManifestAction;
import net.neoforged.neoform.runtime.actions.DownloadLauncherManifestAction;
import net.neoforged.neoform.runtime.actions.DownloadVersionManifestAction;
import net.neoforged.neoform.runtime.actions.ExternalJavaToolAction;
import net.neoforged.neoform.runtime.actions.InjectFromZipFileSource;
import net.neoforged.neoform.runtime.actions.InjectZipContentAction;
import net.neoforged.neoform.runtime.actions.MergeWithSourcesAction;
import net.neoforged.neoform.runtime.actions.PatchActionFactory;
import net.neoforged.neoform.runtime.actions.RecompileSourcesAction;
import net.neoforged.neoform.runtime.actions.RecompileSourcesActionWithECJ;
import net.neoforged.neoform.runtime.actions.RecompileSourcesActionWithJDK;
import net.neoforged.neoform.runtime.actions.RemapSrgSourcesAction;
import net.neoforged.neoform.runtime.actions.SplitResourcesFromClassesAction;
import net.neoforged.neoform.runtime.artifacts.ArtifactManager;
import net.neoforged.neoform.runtime.cache.CacheKey;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.cache.CacheManager;
import net.neoforged.neoform.runtime.cli.FileHashService;
import net.neoforged.neoform.runtime.cli.LockManager;
import net.neoforged.neoform.runtime.config.neoform.NeoFormConfig;
import net.neoforged.neoform.runtime.config.neoform.NeoFormDistConfig;
import net.neoforged.neoform.runtime.config.neoform.NeoFormFunction;
import net.neoforged.neoform.runtime.config.neoform.NeoFormStep;
import net.neoforged.neoform.runtime.engine.BuildOptions;
import net.neoforged.neoform.runtime.engine.DataSource;
import net.neoforged.neoform.runtime.engine.NeoFormInterpolator;
import net.neoforged.neoform.runtime.engine.ProcessGeneration;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import net.neoforged.neoform.runtime.graph.ExecutionGraph;
import net.neoforged.neoform.runtime.graph.ExecutionNode;
import net.neoforged.neoform.runtime.graph.ExecutionNodeBuilder;
import net.neoforged.neoform.runtime.graph.NodeExecutionException;
import net.neoforged.neoform.runtime.graph.NodeInput;
import net.neoforged.neoform.runtime.graph.NodeOutput;
import net.neoforged.neoform.runtime.graph.NodeOutputType;
import net.neoforged.neoform.runtime.graph.ResultRepresentation;
import net.neoforged.neoform.runtime.graph.transforms.GraphTransform;
import net.neoforged.neoform.runtime.graph.transforms.ReplaceNodeOutput;
import net.neoforged.neoform.runtime.utils.AnsiColor;
import net.neoforged.neoform.runtime.utils.Logger;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;
import net.neoforged.neoform.runtime.utils.OsUtil;
import net.neoforged.neoform.runtime.utils.StringUtil;

public class NeoFormEngine
implements AutoCloseable {
    private static final Logger LOG = Logger.create();
    private final ArtifactManager artifactManager;
    private final FileHashService fileHashService;
    private final CacheManager cacheManager;
    private final ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();
    private final Map<ExecutionNode, CompletableFuture<Void>> executingNodes = new IdentityHashMap<ExecutionNode, CompletableFuture<Void>>();
    private final LockManager lockManager;
    private final ExecutionGraph graph = new ExecutionGraph();
    private final BuildOptions buildOptions = new BuildOptions();
    private boolean verbose;
    private ProcessGeneration processGeneration;
    private final Map<String, DataSource> dataSources = new HashMap<String, DataSource>();
    private final List<AutoCloseable> managedResources = new ArrayList<AutoCloseable>();
    private String javaExecutable;

    public NeoFormEngine(ArtifactManager artifactManager, FileHashService fileHashService, CacheManager cacheManager, LockManager lockManager) {
        this.artifactManager = artifactManager;
        this.fileHashService = fileHashService;
        this.cacheManager = cacheManager;
        this.lockManager = lockManager;
        this.javaExecutable = ProcessHandle.current().info().command().orElseThrow();
    }

    @Override
    public void close() throws IOException {
        ArrayList<Exception> suppressedExceptions = new ArrayList<Exception>();
        for (DataSource location : this.dataSources.values()) {
            try {
                location.archive().close();
            }
            catch (Exception e) {
                suppressedExceptions.add(e);
            }
        }
        for (AutoCloseable resource : this.managedResources) {
            try {
                resource.close();
            }
            catch (Exception e) {
                suppressedExceptions.add(e);
            }
        }
        try {
            this.executor.close();
        }
        catch (Exception e) {
            suppressedExceptions.add(e);
        }
        if (!suppressedExceptions.isEmpty()) {
            IOException e = new IOException("Failed to close one or more resources.");
            for (Exception suppressedException : suppressedExceptions) {
                e.addSuppressed(suppressedException);
            }
            throw e;
        }
    }

    public <T extends AutoCloseable> T addManagedResource(T resource) {
        this.managedResources.add(resource);
        return resource;
    }

    public void addDataSource(String id, ZipFile zipFile, String sourceFolder) {
        if (this.dataSources.containsKey(id)) {
            throw new IllegalArgumentException("Data source " + id + " is already defined");
        }
        this.dataSources.put(id, new DataSource(zipFile, sourceFolder));
    }

    public void loadNeoFormData(Path neoFormDataPath, String dist) throws IOException {
        ZipFile zipFile = new ZipFile(neoFormDataPath.toFile());
        NeoFormConfig config = NeoFormConfig.from(zipFile);
        NeoFormDistConfig distConfig = config.getDistConfig(dist);
        for (Map.Entry<String, String> entry : distConfig.getData().entrySet()) {
            this.addDataSource(entry.getKey(), zipFile, entry.getValue());
        }
        this.loadNeoFormProcess(distConfig);
    }

    public void loadNeoFormProcess(NeoFormDistConfig distConfig) {
        this.processGeneration = ProcessGeneration.fromMinecraftVersion(distConfig.minecraftVersion());
        for (NeoFormStep step : distConfig.steps()) {
            this.addNodeForStep(this.graph, distConfig, step);
        }
        NodeOutput renameOutput = this.graph.getRequiredOutput("rename", "output");
        NodeOutput sourcesOutput = this.graph.getRequiredOutput("patch", "output");
        NodeOutput compiledOutput = this.addRecompileStep(distConfig, sourcesOutput);
        NodeOutput sourcesAndCompiledOutput = this.addMergeWithSourcesStep(compiledOutput, sourcesOutput);
        this.graph.setResult("vanillaDeobfuscated", renameOutput);
        this.graph.setResult("sources", sourcesOutput);
        this.graph.setResult("compiled", compiledOutput);
        this.graph.setResult("sourcesAndCompiled", sourcesAndCompiledOutput);
        if (this.graph.hasOutput("stripClient", "resourcesOutput")) {
            this.graph.setResult("clientResources", this.graph.getRequiredOutput("stripClient", "resourcesOutput"));
        }
        if (this.graph.hasOutput("stripServer", "resourcesOutput")) {
            this.graph.setResult("serverResources", this.graph.getRequiredOutput("stripServer", "resourcesOutput"));
        }
        if (this.graph.hasOutput("strip", "resourcesOutput")) {
            this.graph.setResult("resources", this.graph.getRequiredOutput("strip", "resourcesOutput"));
        }
        if (this.processGeneration.sourcesUseIntermediaryNames()) {
            if (!this.graph.hasOutput("mergeMappings", "output") || !this.graph.hasOutput("downloadClientMappings", "output")) {
                throw new IllegalStateException("NFRT currently does not support MCP versions that did not make use of official Mojang mappings (pre 1.17).");
            }
            this.applyTransforms(List.of(new ReplaceNodeOutput("patch", "output", "remapSrgSourcesToOfficial", (builder, previousNodeOutput) -> {
                builder.input("sources", previousNodeOutput.asInput());
                builder.input("mergedMappings", this.graph.getRequiredOutput("mergeMappings", "output").asInput());
                builder.input("officialMappings", this.graph.getRequiredOutput("downloadClientMappings", "output").asInput());
                RemapSrgSourcesAction action = new RemapSrgSourcesAction();
                builder.action(action);
                return builder.output("output", NodeOutputType.ZIP, "Sources with SRG method and field names remapped to official.");
            })));
            ExecutionNodeBuilder createMappings = this.graph.nodeBuilder("createMappings");
            createMappings.inputFromNodeOutput("officialToObf", "downloadClientMappings", "output");
            createMappings.inputFromNodeOutput("obfToSrg", "mergeMappings", "output");
            CreateLegacyMappingsAction action = new CreateLegacyMappingsAction();
            createMappings.action(action);
            this.graph.setResult("namedToIntermediaryMapping", createMappings.output("officialToSrg", NodeOutputType.TSRG, "A mapping file that maps user-facing (Mojang, MCP) names to intermediary (SRG)"));
            this.graph.setResult("intermediaryToNamedMapping", createMappings.output("srgToOfficial", NodeOutputType.SRG, "A mapping file that maps intermediary (SRG) names to user-facing (Mojang, MCP) names"));
            this.graph.setResult("csvMapping", createMappings.output("csvMappings", NodeOutputType.ZIP, "A zip containing csv files with SRG to official mappings"));
            createMappings.build();
        }
    }

    private NodeOutput addRecompileStep(NeoFormDistConfig distConfig, NodeOutput sourcesOutput) {
        ExecutionNodeBuilder builder = this.graph.nodeBuilder("recompile");
        builder.input("sources", sourcesOutput.asInput());
        builder.inputFromNodeOutput("versionManifest", "downloadJson", "output");
        NodeOutput compiledOutput = builder.output("output", NodeOutputType.JAR, "Compiled minecraft sources");
        RecompileSourcesAction compileAction = this.buildOptions.isUseEclipseCompiler() ? new RecompileSourcesActionWithECJ() : new RecompileSourcesActionWithJDK();
        compileAction.setTargetJavaVersion(distConfig.javaVersion());
        compileAction.getClasspath().setOverriddenClasspath(this.buildOptions.getOverriddenCompileClasspath());
        compileAction.getClasspath().addMavenLibraries(distConfig.libraries());
        builder.action(compileAction);
        builder.build();
        return compiledOutput;
    }

    private NodeOutput addMergeWithSourcesStep(NodeOutput compiledOutput, NodeOutput sourcesOutput) {
        ExecutionNodeBuilder builder = this.graph.nodeBuilder("mergeWithSources");
        builder.input("classes", compiledOutput.asInput());
        builder.input("sources", sourcesOutput.asInput());
        NodeOutput output = builder.output("output", NodeOutputType.JAR, "Compiled minecraft sources including sources");
        builder.action(new MergeWithSourcesAction());
        builder.build();
        return output;
    }

    private void addNodeForStep(ExecutionGraph graph, NeoFormDistConfig config, NeoFormStep step) {
        ExecutionNodeBuilder builder = graph.nodeBuilder(step.getId());
        for (Map.Entry<String, String> entry : step.values().entrySet()) {
            HashSet<String> variables = new HashSet<String>();
            NeoFormInterpolator.collectReferencedVariables(entry.getValue(), variables);
            for (String variable : variables) {
                NodeOutput resolvedOutput = graph.getOutput(variable);
                if (resolvedOutput == null) {
                    if (this.dataSources.containsKey(variable)) continue;
                    throw new IllegalArgumentException("Step " + step.type() + " references undeclared output " + variable);
                }
                builder.input(entry.getKey(), resolvedOutput.asInput());
            }
        }
        switch (step.type()) {
            case "downloadManifest": {
                builder.output("output", NodeOutputType.JSON, "Launcher Manifest for all Minecraft versions");
                builder.action(new DownloadLauncherManifestAction(this.artifactManager));
                break;
            }
            case "downloadJson": {
                builder.output("output", NodeOutputType.JSON, "Version manifest for a particular Minecraft version");
                builder.action(new DownloadVersionManifestAction(this.artifactManager, config));
                break;
            }
            case "downloadClient": {
                this.createDownloadFromVersionManifest(builder, "client", NodeOutputType.JAR, "The main Minecraft client jar-file.");
                break;
            }
            case "downloadServer": {
                this.createDownloadFromVersionManifest(builder, "server", NodeOutputType.JAR, "The main Minecraft server jar-file.");
                break;
            }
            case "downloadClientMappings": {
                this.createDownloadFromVersionManifest(builder, "client_mappings", NodeOutputType.TXT, "The official mappings for the Minecraft client jar-file.");
                break;
            }
            case "downloadServerMappings": {
                this.createDownloadFromVersionManifest(builder, "server_mappings", NodeOutputType.TXT, "The official mappings for the Minecraft server jar-file.");
                break;
            }
            case "strip": {
                builder.output("output", NodeOutputType.JAR, "The jar-file that contains only .class files");
                builder.output("resourcesOutput", NodeOutputType.JAR, "The jar-file that contains anything but .class files");
                BuiltInAction action = new SplitResourcesFromClassesAction();
                ((SplitResourcesFromClassesAction)action).addDenyPatterns("META-INF/.*");
                this.processGeneration.getAdditionalDenyListForMinecraftJars().forEach(arg_0 -> NeoFormEngine.lambda$addNodeForStep$1((SplitResourcesFromClassesAction)action, arg_0));
                builder.action(action);
                break;
            }
            case "listLibraries": {
                builder.inputFromNodeOutput("versionManifest", "downloadJson", "output");
                builder.output("output", NodeOutputType.TXT, "A list of all external JAR files needed to decompile/recompile");
                BuiltInAction action = new CreateLibrariesOptionsFileAction();
                ((CreateLibrariesOptionsFileAction)action).getClasspath().setOverriddenClasspath(this.buildOptions.getOverriddenCompileClasspath());
                ((CreateLibrariesOptionsFileAction)action).getClasspath().addMavenLibraries(config.libraries());
                builder.action(action);
                break;
            }
            case "inject": {
                DataSource injectionSource = this.getRequiredDataSource("inject");
                builder.output("output", NodeOutputType.JAR, "Source zip file containing additional NeoForm sources and resources");
                builder.action(new InjectZipContentAction(List.of(new InjectFromZipFileSource(injectionSource.archive(), injectionSource.folder()))));
                break;
            }
            case "patch": {
                DataSource patchSource = this.getRequiredDataSource("patches");
                builder.clearInputs();
                PatchActionFactory.makeAction(builder, Paths.get(patchSource.archive().getName(), new String[0]), config.getDataPathInZip("patches"), graph.getRequiredOutput("inject", "output"), "a/", "b/");
                break;
            }
            default: {
                NeoFormFunction function = config.getFunction(step.type());
                if (function == null) {
                    throw new IllegalArgumentException("Step " + step.getId() + " references undefined function " + step.type());
                }
                this.applyFunctionToNode(step, function, builder);
            }
        }
        builder.build();
    }

    private DataSource getRequiredDataSource(String dataId) {
        DataSource result = this.dataSources.get(dataId);
        if (result == null) {
            throw new IllegalArgumentException("Required data source " + dataId + " not found");
        }
        return result;
    }

    private void applyFunctionToNode(NeoFormStep step, NeoFormFunction function, ExecutionNodeBuilder builder) {
        MavenCoordinate toolArtifactCoordinate;
        ArrayList<String> resolvedJvmArgs = new ArrayList<String>(Objects.requireNonNullElse(function.jvmargs(), List.of()));
        ArrayList<String> resolvedArgs = new ArrayList<String>(Objects.requireNonNullElse(function.args(), List.of()));
        for (Map.Entry<String, String> entry : step.values().entrySet()) {
            UnaryOperator resolver = s -> s.replace("{" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
            resolvedJvmArgs.replaceAll(resolver);
            resolvedArgs.replaceAll(resolver);
        }
        Consumer<String> placeholderProcessor = text -> {
            Matcher matcher = NeoFormInterpolator.TOKEN_PATTERN.matcher((CharSequence)text);
            while (matcher.find()) {
                String variable = matcher.group(1);
                if ("output".equals(variable)) {
                    NodeOutputType type;
                    switch (step.type()) {
                        case "mergeMappings": {
                            NodeOutputType nodeOutputType = NodeOutputType.TSRG;
                            break;
                        }
                        default: {
                            NodeOutputType nodeOutputType = type = NodeOutputType.JAR;
                        }
                    }
                    if (builder.hasOutput(variable)) continue;
                    builder.output(variable, type, "Output of step " + step.type());
                    continue;
                }
                if (this.dataSources.containsKey(variable)) continue;
                if (variable.endsWith("Output")) {
                    String otherStep = variable.substring(0, variable.length() - "Output".length());
                    builder.inputFromNodeOutput(variable, otherStep, "output");
                    continue;
                }
                if (variable.equals("log")) continue;
                throw new IllegalArgumentException("Unsupported variable " + variable + " used by step " + step.getId());
            }
        };
        resolvedJvmArgs.forEach(placeholderProcessor);
        resolvedArgs.forEach(placeholderProcessor);
        try {
            toolArtifactCoordinate = MavenCoordinate.parse(function.toolArtifact());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Function for step " + String.valueOf(step) + " has invalid tool: " + function.toolArtifact());
        }
        ExternalJavaToolAction action = new ExternalJavaToolAction(toolArtifactCoordinate);
        action.setRepositoryUrl(function.repository());
        action.setJvmArgs(resolvedJvmArgs);
        action.setArgs(resolvedArgs);
        builder.action(action);
    }

    private void createDownloadFromVersionManifest(ExecutionNodeBuilder builder, String manifestEntry, NodeOutputType jar, String description) {
        builder.inputFromNodeOutput("versionManifest", "downloadJson", "output");
        builder.output("output", jar, description);
        builder.action(new DownloadFromVersionManifestAction(this.artifactManager, manifestEntry));
    }

    private void triggerAndWait(Collection<ExecutionNode> nodes) throws InterruptedException {
        record Pair(ExecutionNode node, CompletableFuture<Void> future) {
        }
        List<Pair> pairs = nodes.stream().map(node -> new Pair((ExecutionNode)node, this.getWaitCondition((ExecutionNode)node))).toList();
        for (Pair pair : pairs) {
            try {
                pair.future.get();
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)throwable;
                    throw runtimeException;
                }
                throw new NodeExecutionException(pair.node, e.getCause());
            }
        }
    }

    private synchronized CompletableFuture<Void> getWaitCondition(ExecutionNode node) {
        CompletableFuture<Void> future = this.executingNodes.get(node);
        if (future == null) {
            future = CompletableFuture.runAsync(() -> {
                String originalName = Thread.currentThread().getName();
                try {
                    Thread.currentThread().setName("run-" + node.id());
                    this.runNode(node);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    Thread.currentThread().setName(originalName);
                }
            }, this.executor);
            this.executingNodes.put(node, future);
        }
        return future;
    }

    public void runNode(ExecutionNode node) throws InterruptedException {
        Set<ExecutionNode> dependencies = Collections.newSetFromMap(new IdentityHashMap());
        for (NodeInput nodeInput : node.inputs().values()) {
            dependencies.addAll(nodeInput.getNodeDependencies());
        }
        this.triggerAndWait(dependencies);
        CacheKeyBuilder ck = new CacheKeyBuilder(node.id(), this.fileHashService);
        for (Map.Entry<String, NodeInput> entry : node.inputs().entrySet()) {
            entry.getValue().collectCacheKeyComponent(ck);
        }
        node.action().computeCacheKey(ck);
        node.start();
        CacheKey cacheKey = ck.build();
        if (this.verbose) {
            LOG.println(" Cache Key: " + String.valueOf(cacheKey));
            LOG.println(String.valueOf((Object)AnsiColor.MUTED) + StringUtil.indent(cacheKey.describe(), 2) + String.valueOf((Object)AnsiColor.RESET));
        }
        try (LockManager.Lock lock = this.lockManager.lock(cacheKey.toString());){
            HashMap<String, Path> outputValues = new HashMap<String, Path>();
            if (this.cacheManager.restoreOutputsFromCache(node, cacheKey, outputValues)) {
                node.complete(outputValues, true);
                return;
            }
            Path workspace = this.cacheManager.createWorkspace(node.id());
            node.action().run(new NodeProcessingEnvironment(workspace, node, outputValues));
            if (outputValues.values().stream().allMatch(p -> p.startsWith(workspace))) {
                this.cacheManager.saveOutputs(node, cacheKey, outputValues);
            }
            node.complete(outputValues, false);
        }
        catch (Throwable throwable) {
            node.fail();
            throw new NodeExecutionException(node, throwable);
        }
    }

    public ArtifactManager getArtifactManager() {
        return this.artifactManager;
    }

    public Set<String> getAvailableResults() {
        return this.graph.getResults().keySet();
    }

    public Map<String, Path> createResults(String ... ids) throws InterruptedException {
        Set<ExecutionNode> nodes = Collections.newSetFromMap(new IdentityHashMap());
        for (String id : ids) {
            NodeOutput nodeOutput = this.graph.getResult(id);
            if (nodeOutput == null) {
                throw new IllegalArgumentException("Unknown result: " + id + ". Available results: " + String.valueOf(this.getAvailableResults()));
            }
            nodes.add(nodeOutput.getNode());
        }
        this.triggerAndWait(nodes);
        HashMap<String, Path> results = new HashMap<String, Path>();
        for (String id : ids) {
            NodeOutput nodeOutput = this.graph.getResult(id);
            results.put(id, nodeOutput.getResultPath());
        }
        return results;
    }

    public void dumpGraph(PrintWriter printWriter) {
        this.graph.dump(printWriter);
    }

    public void applyTransforms(List<GraphTransform> transforms) {
        for (GraphTransform transform : transforms) {
            transform.apply(this, this.graph);
        }
    }

    public void applyTransform(GraphTransform transform) {
        transform.apply(this, this.graph);
    }

    public ExecutionGraph getGraph() {
        return this.graph;
    }

    public BuildOptions getBuildOptions() {
        return this.buildOptions;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public ProcessGeneration getProcessGeneration() {
        return this.processGeneration;
    }

    public void setJavaHome(Path javaHome) {
        Path javaExecutable = OsUtil.isWindows() ? javaHome.resolve("bin/java.exe") : javaHome.resolve("bin/java");
        if (!Files.isExecutable(javaExecutable)) {
            throw new RuntimeException("Could not find a Java executable in the given Java home: " + String.valueOf(javaExecutable));
        }
        this.javaExecutable = javaExecutable.toString();
    }

    public String getJavaExecutable() {
        return this.javaExecutable;
    }

    public void setJavaExecutable(String javaExecutable) {
        this.javaExecutable = javaExecutable;
    }

    private static /* synthetic */ void lambda$addNodeForStep$1(SplitResourcesFromClassesAction rec$, String xva$0) {
        rec$.addDenyPatterns(xva$0);
    }

    private class NodeProcessingEnvironment
    implements ProcessingEnvironment {
        private final Path workspace;
        private final ExecutionNode node;
        private final Map<String, Path> outputValues;

        public NodeProcessingEnvironment(Path workspace, ExecutionNode node, Map<String, Path> outputValues) {
            this.workspace = workspace;
            this.node = node;
            this.outputValues = outputValues;
        }

        @Override
        public ArtifactManager getArtifactManager() {
            return NeoFormEngine.this.artifactManager;
        }

        @Override
        public Path getWorkspace() {
            return this.workspace;
        }

        @Override
        public String getJavaExecutable() {
            return NeoFormEngine.this.javaExecutable;
        }

        @Override
        public String interpolateString(String text) throws IOException {
            Matcher matcher = NeoFormInterpolator.TOKEN_PATTERN.matcher(text);
            StringBuilder result = new StringBuilder();
            while (matcher.find()) {
                String variableValue = this.getVariableValue(matcher.group(1));
                String replacement = Matcher.quoteReplacement(variableValue);
                matcher.appendReplacement(result, replacement);
            }
            matcher.appendTail(result);
            return result.toString();
        }

        private String getVariableValue(String variable) throws IOException {
            Path resultPath;
            NodeInput nodeInput = this.node.inputs().get(variable);
            if (nodeInput != null) {
                resultPath = nodeInput.getValue(ResultRepresentation.PATH);
            } else if (this.node.outputs().containsKey(variable)) {
                resultPath = this.getOutputPath(variable);
            } else if (NeoFormEngine.this.dataSources.containsKey(variable)) {
                resultPath = this.extractData(variable);
            } else if ("log".equals(variable)) {
                resultPath = this.workspace.resolve("log.txt");
            } else {
                throw new IllegalArgumentException("Variable " + variable + " is neither an input, output or configuration data");
            }
            return this.getPathArgument(resultPath);
        }

        @Override
        public Path extractData(String dataId) throws IOException {
            String dataPath;
            DataSource dataSource = NeoFormEngine.this.dataSources.get(dataId);
            if (dataSource == null) {
                throw new IllegalArgumentException("Could not find data source " + dataId + ". Available: " + String.valueOf(NeoFormEngine.this.dataSources.keySet()));
            }
            ZipFile archive = dataSource.archive();
            ZipEntry rootEntry = archive.getEntry(dataPath = dataSource.folder());
            if (rootEntry == null) {
                throw new IllegalArgumentException("NeoForm archive entry " + dataPath + " does not exist in " + archive.getName() + ".");
            }
            if (rootEntry.getName().startsWith("/") || rootEntry.getName().contains("..")) {
                throw new IllegalArgumentException("Unsafe ZIP path: " + rootEntry.getName());
            }
            if (rootEntry.isDirectory()) {
                Path targetDirPath = this.workspace.resolve(rootEntry.getName());
                if (!Files.exists(targetDirPath, new LinkOption[0])) {
                    try {
                        Files.createDirectories(targetDirPath, new FileAttribute[0]);
                        Iterator<? extends ZipEntry> entryIter = archive.entries().asIterator();
                        while (entryIter.hasNext()) {
                            ZipEntry entry = entryIter.next();
                            if (entry.isDirectory() || !entry.getName().startsWith(rootEntry.getName())) continue;
                            String relativePath = entry.getName().substring(rootEntry.getName().length());
                            Path targetPath = targetDirPath.resolve(relativePath).normalize();
                            if (!targetPath.startsWith(targetDirPath)) {
                                throw new IllegalArgumentException("Directory escape: " + String.valueOf(targetPath));
                            }
                            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                            InputStream in = archive.getInputStream(entry);
                            try {
                                Files.copy(in, targetPath, new CopyOption[0]);
                            }
                            finally {
                                if (in == null) continue;
                                in.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to extract referenced NeoForm data " + dataPath + " to " + String.valueOf(targetDirPath), e);
                    }
                }
                return targetDirPath;
            }
            Path path = this.workspace.resolve(rootEntry.getName());
            if (!Files.exists(path, new LinkOption[0])) {
                try {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (InputStream in = archive.getInputStream(rootEntry);){
                        Files.copy(in, path, new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to extract referenced NeoForm data " + dataPath + " to " + String.valueOf(path), e);
                }
            }
            return path;
        }

        @Override
        public <T> T getRequiredInput(String id, ResultRepresentation<T> representation) throws IOException {
            return this.node.getRequiredInput(id).getValue(representation);
        }

        @Override
        public Path getOutputPath(String id) {
            NodeOutput output = this.node.getRequiredOutput(id);
            String filename = id + output.type().getExtension();
            Path path = this.workspace.resolve(filename);
            this.setOutput(id, path);
            return path;
        }

        @Override
        public void setOutput(String id, Path resultPath) {
            this.node.getRequiredOutput(id);
            if (this.outputValues.containsKey(id)) {
                throw new IllegalStateException("Path for node output " + id + " is already set.");
            }
            this.outputValues.put(id, resultPath);
        }

        @Override
        public boolean isVerbose() {
            return NeoFormEngine.this.verbose;
        }
    }
}

