/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cli;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import net.neoforged.neoform.runtime.artifacts.ArtifactManager;
import net.neoforged.neoform.runtime.artifacts.ClasspathItem;
import net.neoforged.neoform.runtime.cache.CacheManager;
import net.neoforged.neoform.runtime.cache.LauncherInstallations;
import net.neoforged.neoform.runtime.cli.FileHashService;
import net.neoforged.neoform.runtime.cli.LockManager;
import net.neoforged.neoform.runtime.cli.Main;
import net.neoforged.neoform.runtime.downloads.DownloadManager;
import net.neoforged.neoform.runtime.engine.NeoFormEngine;
import net.neoforged.neoform.runtime.utils.Logger;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

public abstract class NeoFormEngineCommand
implements Callable<Integer> {
    private static final Logger LOG = Logger.create();
    @CommandLine.ParentCommand
    Main commonOptions;
    @CommandLine.Option(names={"--print-graph"})
    boolean printGraph;
    @CommandLine.Option(names={"--use-eclipse-compiler"})
    boolean useEclipseCompiler;
    @CommandLine.Option(names={"--compile-classpath"})
    String compileClasspath;
    @CommandLine.Option(names={"--disable-cache"})
    boolean disableCache;
    @CommandLine.Option(names={"--analyze-cache-misses"})
    boolean analyzeCacheMisses;
    @CommandLine.Option(names={"--disable-cache-maintenance"}, description={"Skip automatically running cache maintenance from time to time"})
    boolean disableCacheMaintenance;
    @CommandLine.Option(names={"--java-home"}, description={"The home of the JRE to run external tools with. If not specified, the Java running NFRT will be used."})
    @Nullable
    Path javaHome;
    @CommandLine.Option(names={"--java-executable"}, description={"The path to the Java executable to run external tools with. If not specified, the Java running NFRT will be used."})
    @Nullable
    Path javaExecutable;

    protected abstract void runWithNeoFormEngine(NeoFormEngine var1, List<AutoCloseable> var2) throws IOException, InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Integer call() throws Exception {
        long start = System.currentTimeMillis();
        ArrayList<AutoCloseable> closables = new ArrayList<AutoCloseable>();
        LauncherInstallations launcherInstallations = this.commonOptions.createLauncherInstallations();
        try (CacheManager cacheManager = this.commonOptions.createCacheManager();
             DownloadManager downloadManager = new DownloadManager();){
            LockManager lockManager = this.commonOptions.createLockManager();
            cacheManager.setDisabled(this.disableCache);
            cacheManager.setAnalyzeMisses(this.analyzeCacheMisses);
            if (!this.disableCacheMaintenance) {
                cacheManager.performMaintenance();
            }
            ArtifactManager artifactManager = this.commonOptions.createArtifactManager(cacheManager, downloadManager, lockManager, launcherInstallations);
            FileHashService fileHashService = new FileHashService();
            try (NeoFormEngine engine = new NeoFormEngine(artifactManager, fileHashService, cacheManager, lockManager);){
                if (this.javaExecutable != null) {
                    engine.setJavaExecutable(this.javaExecutable.toString());
                } else if (this.javaHome != null) {
                    engine.setJavaHome(this.javaHome);
                }
                engine.setVerbose(this.commonOptions.verbose);
                this.applyBuildOptions(engine);
                this.runWithNeoFormEngine(engine, closables);
            }
        }
        catch (Throwable throwable) {
            for (AutoCloseable closable : closables) {
                try {
                    closable.close();
                }
                catch (Exception e) {
                    System.err.println("Failed to close " + String.valueOf(closable) + ": " + String.valueOf(e));
                }
            }
            long elapsed = System.currentTimeMillis() - start;
            LOG.println(String.format(Locale.ROOT, "Total runtime: %.02fs\n", (double)elapsed / 1000.0));
            throw throwable;
        }
        for (AutoCloseable closable : closables) {
            try {
                closable.close();
            }
            catch (Exception e) {
                System.err.println("Failed to close " + String.valueOf(closable) + ": " + String.valueOf(e));
            }
        }
        long elapsed = System.currentTimeMillis() - start;
        LOG.println(String.format(Locale.ROOT, "Total runtime: %.02fs\n", (double)elapsed / 1000.0));
        return 0;
    }

    private void applyBuildOptions(NeoFormEngine engine) {
        engine.getBuildOptions().setUseEclipseCompiler(this.useEclipseCompiler);
        if (this.compileClasspath != null) {
            List<ClasspathItem> compileClasspath = Arrays.stream(this.compileClasspath.split(Pattern.quote(File.pathSeparator))).map(x$0 -> Paths.get(x$0, new String[0])).map(ClasspathItem::of).toList();
            engine.getBuildOptions().setOverriddenCompileClasspath(compileClasspath);
        }
    }
}

