/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import net.neoforged.neoform.runtime.actions.InjectFromZipFileSource;

public class StripManifestDigestContentFilter
implements InjectFromZipFileSource.ContentFilter {
    private static final Set<Attributes.Name> SIGNATURE_ATTRIBUTES = Set.of(new Attributes.Name("Magic"), new Attributes.Name("SHA-256-Digest"), new Attributes.Name("SHA1-Digest"));
    public static final StripManifestDigestContentFilter INSTANCE = new StripManifestDigestContentFilter();

    private StripManifestDigestContentFilter() {
    }

    @Override
    public void copy(ZipEntry entry, InputStream in, OutputStream out) throws IOException {
        if (!entry.getName().equals("META-INF/MANIFEST.MF")) {
            in.transferTo(out);
        } else {
            Manifest manifest = new Manifest(in);
            Iterator<Attributes> it = manifest.getEntries().values().iterator();
            while (it.hasNext()) {
                Attributes entryAttrs = it.next();
                entryAttrs.keySet().removeIf(SIGNATURE_ATTRIBUTES::contains);
                if (!entryAttrs.isEmpty()) continue;
                it.remove();
            }
            manifest.write(out);
        }
    }
}

