/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.graph;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.neoforged.neoform.runtime.graph.ExecutionGraph;
import net.neoforged.neoform.runtime.graph.ExecutionNode;
import net.neoforged.neoform.runtime.graph.ExecutionNodeAction;
import net.neoforged.neoform.runtime.graph.NodeInput;
import net.neoforged.neoform.runtime.graph.NodeOutput;
import net.neoforged.neoform.runtime.graph.NodeOutputType;

public class ExecutionNodeBuilder {
    private final String id;
    private final ExecutionGraph graph;
    private final Map<String, NodeInput> nodeInputs = new HashMap<String, NodeInput>();
    private final Map<String, NodeOutput> nodeOutputs = new HashMap<String, NodeOutput>();
    private ExecutionNodeAction action;

    public ExecutionNodeBuilder(ExecutionGraph graph, String id) {
        this.graph = graph;
        this.id = Objects.requireNonNull(id, "id");
    }

    public boolean hasInput(String inputId) {
        return this.nodeInputs.containsKey(inputId);
    }

    public NodeInput input(String inputId, NodeInput input) {
        if (this.nodeInputs.containsKey(inputId)) {
            throw new IllegalArgumentException("Duplicate input " + inputId + " on node " + this.id);
        }
        this.nodeInputs.put(inputId, Objects.requireNonNull(input, "input"));
        return input;
    }

    public NodeInput inputFromNodeOutput(String inputId, String nodeId, String outputId) {
        ExecutionNode node = this.graph.getNode(nodeId);
        if (node == null) {
            throw new IllegalArgumentException("Node " + nodeId + " not found");
        }
        NodeOutput output = node.getRequiredOutput(outputId);
        return this.input(inputId, new NodeInput.NodeInputForOutput(output));
    }

    public boolean hasOutput(String outputId) {
        return this.nodeOutputs.containsKey(outputId);
    }

    public NodeOutput output(String outputId, NodeOutputType type, String description) {
        if (this.nodeOutputs.keySet().stream().anyMatch(existingId -> existingId.equalsIgnoreCase(outputId))) {
            throw new IllegalArgumentException("Duplicate output " + outputId + " on node " + this.id);
        }
        NodeOutput value = new NodeOutput(outputId, type, description);
        this.nodeOutputs.put(outputId, value);
        return value;
    }

    public void action(ExecutionNodeAction work) {
        this.action = work;
    }

    public void clearInputs() {
        this.nodeInputs.clear();
    }

    public ExecutionNode build() {
        if (this.action == null) {
            throw new IllegalStateException("No action registered for node " + this.id);
        }
        ExecutionNode node = new ExecutionNode(this.id, this.nodeInputs, this.nodeOutputs, this.action);
        this.graph.add(node);
        return node;
    }
}

