/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cli;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import net.neoforged.neoform.runtime.artifacts.Artifact;
import net.neoforged.neoform.runtime.artifacts.ArtifactManager;
import net.neoforged.neoform.runtime.cache.CacheManager;
import net.neoforged.neoform.runtime.cache.LauncherInstallations;
import net.neoforged.neoform.runtime.cli.LockManager;
import net.neoforged.neoform.runtime.cli.Main;
import net.neoforged.neoform.runtime.config.neoforge.NeoForgeConfig;
import net.neoforged.neoform.runtime.config.neoform.NeoFormConfig;
import net.neoforged.neoform.runtime.downloads.AssetDownloadResult;
import net.neoforged.neoform.runtime.downloads.AssetDownloader;
import net.neoforged.neoform.runtime.downloads.DownloadManager;
import net.neoforged.neoform.runtime.downloads.DownloadsFailedException;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;
import picocli.CommandLine;

@CommandLine.Command(name="download-assets", description={"Download the client assets used to run a particular game version"})
public class DownloadAssetsCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    Main commonOptions;
    @CommandLine.ArgGroup(multiplicity="1")
    public Version version;
    @CommandLine.Option(names={"--asset-repository"})
    public URI assetRepository = URI.create("https://resources.download.minecraft.net/");
    @CommandLine.Option(names={"--copy-launcher-assets"}, description={"Try to find the Minecraft Launcher in common locations and copy its assets"}, negatable=true, fallbackValue="true")
    public boolean copyLauncherAssets = true;
    @CommandLine.Option(names={"--use-launcher-asset-root"}, description={"Try to find an existing Minecraft Launcher asset root, and use it to store the requested assets"}, negatable=true, fallbackValue="true")
    public boolean useLauncherAssetRoot = true;
    @CommandLine.Option(names={"--concurrent-downloads"})
    public int concurrentDownloads = 25;
    @CommandLine.Option(names={"--write-properties"})
    public Path outputPropertiesPath;
    @CommandLine.Option(names={"--write-json"})
    public Path outputJsonPath;

    @Override
    public Integer call() throws Exception {
        DownloadManager downloadManager = new DownloadManager();
        try {
            Integer n;
            block18: {
                AssetDownloadResult result;
                CacheManager cacheManager = this.commonOptions.createCacheManager();
                try {
                    LockManager lockManager = this.commonOptions.createLockManager();
                    LauncherInstallations launcherInstallations = this.commonOptions.createLauncherInstallations();
                    ArtifactManager artifactManager = this.commonOptions.createArtifactManager(cacheManager, downloadManager, lockManager, launcherInstallations);
                    String minecraftVersion = this.getMinecraftVersion(artifactManager);
                    AssetDownloader downloader = new AssetDownloader(downloadManager, artifactManager, launcherInstallations, cacheManager);
                    try {
                        result = downloader.downloadAssets(minecraftVersion, this.assetRepository, this.useLauncherAssetRoot, this.copyLauncherAssets, this.concurrentDownloads);
                    }
                    catch (DownloadsFailedException e) {
                        System.err.println(e.getErrors().size() + " files failed to download");
                        System.err.println("First error:");
                        e.getErrors().getFirst().printStackTrace();
                        Integer n2 = 1;
                        if (cacheManager != null) {
                            cacheManager.close();
                        }
                        downloadManager.close();
                        return n2;
                    }
                }
                catch (Throwable throwable) {
                    if (cacheManager != null) {
                        try {
                            cacheManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                if (this.outputPropertiesPath != null) {
                    result.writeAsProperties(this.outputPropertiesPath);
                }
                if (this.outputJsonPath != null) {
                    result.writeAsJson(this.outputJsonPath);
                }
                n = 0;
                if (cacheManager == null) break block18;
                cacheManager.close();
            }
            return n;
        }
        finally {
            try {
                downloadManager.close();
            }
            catch (Throwable throwable) {
                Throwable throwable3;
                throwable3.addSuppressed(throwable);
            }
        }
    }

    private String getMinecraftVersion(ArtifactManager artifactManager) throws IOException {
        MavenCoordinate neoformArtifact;
        if (this.version.minecraftVersion != null) {
            return this.version.minecraftVersion;
        }
        if (this.version.neoformArtifact != null) {
            neoformArtifact = MavenCoordinate.parse(this.version.neoformArtifact);
        } else {
            Artifact neoforgeArtifact = artifactManager.get(this.version.neoforgeArtifact);
            try (JarFile neoforgeZipFile = new JarFile(neoforgeArtifact.path().toFile());){
                NeoForgeConfig neoforgeConfig = NeoForgeConfig.from(neoforgeZipFile);
                neoformArtifact = MavenCoordinate.parse(neoforgeConfig.neoformArtifact());
            }
        }
        Artifact neoFormArchive = artifactManager.get(neoformArtifact);
        try (ZipFile zipFile = new ZipFile(neoFormArchive.path().toFile());){
            String string = NeoFormConfig.from(zipFile).minecraftVersion();
            return string;
        }
    }

    public static class Version {
        @CommandLine.Option(names={"--minecraft-version"})
        String minecraftVersion;
        @CommandLine.Option(names={"--neoform"})
        String neoformArtifact;
        @CommandLine.Option(names={"--neoforge"})
        String neoforgeArtifact;
    }
}

