/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.manifests;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Objects;
import net.neoforged.neoform.runtime.manifests.MinecraftDownload;
import net.neoforged.neoform.runtime.manifests.Rule;
import net.neoforged.neoform.runtime.manifests.RuleAction;
import org.jetbrains.annotations.Nullable;

public record MinecraftLibrary(@SerializedName(value="name") String artifactId, Downloads downloads, List<Rule> rules) {
    public MinecraftLibrary {
        Objects.requireNonNull(artifactId, "name");
        rules = Objects.requireNonNullElseGet(rules, List::of);
    }

    public boolean rulesMatch() {
        if (this.rules.isEmpty()) {
            return true;
        }
        for (Rule rule : this.rules) {
            boolean ruleApplies = rule.evaluate();
            if (!ruleApplies && rule.action() == RuleAction.ALLOWED) {
                return false;
            }
            if (!ruleApplies || rule.action() != RuleAction.DISALLOWED) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public MinecraftDownload getArtifactDownload() {
        return this.downloads != null ? this.downloads.artifact : null;
    }

    @Override
    public String toString() {
        return this.artifactId;
    }

    public record Downloads(MinecraftDownload artifact) {
    }
}

