/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cli;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HexFormat;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import net.neoforged.neoform.runtime.artifacts.Artifact;
import net.neoforged.neoform.runtime.artifacts.ArtifactManager;
import net.neoforged.neoform.runtime.cache.CacheManager;
import net.neoforged.neoform.runtime.cli.Main;
import net.neoforged.neoform.runtime.config.neoforge.NeoForgeConfig;
import net.neoforged.neoform.runtime.config.neoform.NeoFormConfig;
import net.neoforged.neoform.runtime.downloads.DownloadManager;
import net.neoforged.neoform.runtime.downloads.DownloadSpec;
import net.neoforged.neoform.runtime.manifests.AssetIndex;
import net.neoforged.neoform.runtime.manifests.AssetIndexReference;
import net.neoforged.neoform.runtime.manifests.AssetObject;
import net.neoforged.neoform.runtime.manifests.MinecraftVersionManifest;
import net.neoforged.neoform.runtime.utils.Logger;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;
import net.neoforged.neoform.runtime.utils.StringUtil;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(name="download-assets", description={"Download the client assets used to run a particular game version"})
public class DownloadAssetsCommand
implements Callable<Integer> {
    private static final Logger LOG = Logger.create();
    private static final ThreadFactory DOWNLOAD_THREAD_FACTORY = r -> Thread.ofVirtual().name("download-asset", 1L).unstarted(r);
    @CommandLine.ParentCommand
    Main commonOptions;
    @CommandLine.ArgGroup(multiplicity="1")
    public Version version;
    @CommandLine.Option(names={"--asset-repository"})
    public URI assetRepository = URI.create("https://resources.download.minecraft.net/");
    @CommandLine.Option(names={"--concurrent-downloads"})
    public int concurrentDownloads = 25;
    @CommandLine.Option(names={"--output-properties-to"})
    public String outputPropertiesPath;

    private String getMinecraftVersion(ArtifactManager artifactManager) throws IOException {
        MavenCoordinate neoformArtifact;
        if (this.version.minecraftVersion != null) {
            return this.version.minecraftVersion;
        }
        if (this.version.neoformArtifact != null) {
            neoformArtifact = MavenCoordinate.parse(this.version.neoformArtifact);
        } else {
            Artifact neoforgeArtifact = artifactManager.get(this.version.neoforgeArtifact);
            try (JarFile neoforgeZipFile = new JarFile(neoforgeArtifact.path().toFile());){
                NeoForgeConfig neoforgeConfig = NeoForgeConfig.from(neoforgeZipFile);
                neoformArtifact = MavenCoordinate.parse(neoforgeConfig.neoformArtifact());
            }
        }
        Artifact neoFormArchive = artifactManager.get(neoformArtifact);
        try (ZipFile zipFile = new ZipFile(neoFormArchive.path().toFile());){
            String string = NeoFormConfig.from(zipFile).minecraftVersion();
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Integer call() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int downloadAssets(DownloadManager downloadManager, ArtifactManager artifactManager, CacheManager cacheManager) throws IOException {
        String minecraftVersion = this.getMinecraftVersion(artifactManager);
        MinecraftVersionManifest versionManifest = MinecraftVersionManifest.from(artifactManager.getVersionManifest(minecraftVersion).path());
        AssetIndexReference assetIndexReference = versionManifest.assetIndex();
        LOG.println("Downloading asset index " + assetIndexReference.id());
        Path assetRoot = cacheManager.getAssetsDir();
        Path indexFolder = assetRoot.resolve("indexes");
        Files.createDirectories(indexFolder, new FileAttribute[0]);
        Path objectsFolder = assetRoot.resolve("objects");
        Files.createDirectories(objectsFolder, new FileAttribute[0]);
        Path assetIndexPath = indexFolder.resolve(assetIndexReference.id() + ".json");
        downloadManager.download(assetIndexReference, assetIndexPath);
        for (int i = 0; i < 256; ++i) {
            Path objectSubFolder = objectsFolder.resolve(HexFormat.of().toHexDigits(i, 2));
            Files.createDirectories(objectSubFolder, new FileAttribute[0]);
        }
        AtomicInteger downloadsDone = new AtomicInteger();
        AtomicLong bytesDownloaded = new AtomicLong();
        ArrayList errors = new ArrayList();
        AssetIndex assetIndex = AssetIndex.from(assetIndexPath);
        List<AssetObject> objectsToDownload = assetIndex.objects().values().stream().distinct().filter(obj -> Files.notExists(objectsFolder.resolve(DownloadAssetsCommand.getObjectPath(obj)), new LinkOption[0])).toList();
        if (this.concurrentDownloads < 1) {
            throw new IllegalStateException("Cannot set concurrent downloads to less than 1: " + this.concurrentDownloads);
        }
        Semaphore semaphore = new Semaphore(this.concurrentDownloads);
        try (ExecutorService executor = Executors.newThreadPerTaskExecutor(DOWNLOAD_THREAD_FACTORY);){
            for (AssetObject object : objectsToDownload) {
                AssetDownloadSpec spec = new AssetDownloadSpec(object);
                String objectHash = object.hash();
                String objectPath = objectHash.substring(0, 2) + "/" + objectHash;
                Path objectLocation = objectsFolder.resolve(objectPath);
                executor.execute(() -> {
                    boolean hasAcquired = false;
                    try {
                        semaphore.acquire();
                        hasAcquired = true;
                        if (downloadManager.download(spec, objectLocation, true)) {
                            bytesDownloaded.addAndGet(spec.size());
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        ArrayList arrayList = errors;
                        synchronized (arrayList) {
                            errors.add(e);
                        }
                    }
                    finally {
                        int finished;
                        if (hasAcquired) {
                            semaphore.release();
                        }
                        if ((finished = downloadsDone.incrementAndGet()) % 100 == 0) {
                            LOG.println(finished + "/" + objectsToDownload.size() + " downloads");
                        }
                    }
                });
            }
        }
        LOG.println("Downloaded " + objectsToDownload.size() + " assets with a total size of " + StringUtil.formatBytes(bytesDownloaded.get()));
        if (!errors.isEmpty()) {
            System.err.println(errors.size() + " files failed to download");
            System.err.println("First error:");
            ((Exception)errors.getFirst()).printStackTrace();
            return 1;
        }
        if (this.outputPropertiesPath != null) {
            Properties properties = new Properties();
            properties.put("assets_root", assetRoot.toAbsolutePath().toString());
            properties.put("asset_index", assetIndexReference.id());
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(Paths.get(this.outputPropertiesPath, new String[0]), new OpenOption[0]));){
                properties.store(out, null);
            }
        }
        return 0;
    }

    private static String getObjectPath(AssetObject object) {
        String objectHash = object.hash();
        return objectHash.substring(0, 2) + "/" + objectHash;
    }

    public static class Version {
        @CommandLine.Option(names={"--minecraft-version"})
        String minecraftVersion;
        @CommandLine.Option(names={"--neoform"})
        String neoformArtifact;
        @CommandLine.Option(names={"--neoforge"})
        String neoforgeArtifact;
    }

    private class AssetDownloadSpec
    implements DownloadSpec {
        private final AssetObject object;

        public AssetDownloadSpec(AssetObject object) {
            this.object = object;
        }

        @Override
        public URI uri() {
            return URI.create(DownloadAssetsCommand.this.assetRepository.toString() + DownloadAssetsCommand.getObjectPath(this.object));
        }

        @Override
        public int size() {
            return this.object.size();
        }

        @Override
        @Nullable
        public String checksum() {
            return this.object.hash();
        }

        @Override
        @Nullable
        public String checksumAlgorithm() {
            return "SHA1";
        }
    }
}

