/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cache;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.neoform.runtime.utils.AnsiColor;
import net.neoforged.neoform.runtime.utils.Logger;
import org.jetbrains.annotations.Nullable;

public class LauncherInstallations {
    private static final Logger LOG = Logger.create();
    private static final String[] CANDIDATES = new String[]{"${env.APPDATA}/.minecraft/", "${user.home}/.minecraft/", "${user.home}/Library/Application Support/minecraft/", "${user.home}/curseforge/minecraft/Install/", "${env.APPDATA}/com.modrinth.theseus/meta/", "${env.LOCALAPPDATA}/.ftba/bin/", "${user.home}/.ftba/bin/", "${user.home}/Library/Application Support/.ftba/bin/", "${user.home}/.local/share/PrismLauncher/", "${user.home}/.local/share/multimc/", "${user.home}/Library/Application Support/PrismLauncher/", "${env.APPDATA}/PrismLauncher/", "${user.home}/scoop/persist/multimc/"};
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{([^}]+)}");
    private final List<LauncherDirectory> launcherDirectories = new ArrayList<LauncherDirectory>();
    private boolean scanned;
    private boolean verbose;

    public LauncherInstallations(List<Path> additionalLauncherDirs) {
        for (Path dir : additionalLauncherDirs) {
            LauncherDirectory launcherDir = this.analyzeLauncherDirectory(dir);
            if (launcherDir == null) continue;
            this.launcherDirectories.add(launcherDir);
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public List<Path> getInstallationRoots() {
        this.scanIfNecessary();
        return this.launcherDirectories.stream().map(LauncherDirectory::directory).toList();
    }

    private void scanIfNecessary() {
        if (this.scanned) {
            return;
        }
        this.scanned = true;
        if ("true".equals(System.getenv("CI"))) {
            if (this.verbose) {
                LOG.println("Not scanning for Minecraft Launcher installations in CI");
            }
            return;
        }
        if (this.verbose) {
            LOG.println("Scanning for Minecraft Launcher installations");
        }
        for (String candidate : CANDIDATES) {
            String resolvedPath = this.resolvePlaceholders(candidate);
            if (resolvedPath == null) continue;
            try {
                LauncherDirectory result = this.analyzeLauncherDirectory(Paths.get(candidate, new String[0]));
                if (result == null) continue;
                this.launcherDirectories.add(result);
            }
            catch (Exception e) {
                if (!this.verbose) continue;
                LOG.println(" Failed to scan launcher directory " + candidate + ": " + String.valueOf(e));
            }
        }
        if (this.verbose) {
            LOG.println("Launcher directories found:");
            for (LauncherDirectory launcherDirectory : this.launcherDirectories) {
                LOG.println(String.valueOf((Object)AnsiColor.MUTED) + "  " + String.valueOf(launcherDirectory.directory) + String.valueOf((Object)AnsiColor.RESET));
            }
        }
    }

    @Nullable
    private String resolvePlaceholders(String candidate) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(candidate);
        ArrayList unmatchedVariables = new ArrayList();
        candidate = matcher.replaceAll(match -> {
            String variable = match.group(1);
            String value = variable.startsWith("env.") ? System.getenv(variable.substring("env.".length())) : System.getProperty(variable);
            if (value == null) {
                unmatchedVariables.add(variable);
                return "";
            }
            return Matcher.quoteReplacement(value);
        });
        if (!unmatchedVariables.isEmpty()) {
            if (this.verbose) {
                LOG.println("  Skipping candidate " + candidate + " due to undefined references: " + String.valueOf(unmatchedVariables));
            }
            return null;
        }
        return candidate;
    }

    @Nullable
    private LauncherDirectory analyzeLauncherDirectory(Path installDir) {
        if (!Files.isDirectory(installDir, new LinkOption[0])) {
            if (this.verbose) {
                LOG.println(String.valueOf((Object)AnsiColor.MUTED) + " Not found: " + String.valueOf(installDir) + String.valueOf((Object)AnsiColor.RESET));
            }
            return null;
        }
        return new LauncherDirectory(installDir);
    }

    private record LauncherDirectory(Path directory) {
    }
}

