/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.IOException;
import net.neoforged.neoform.runtime.actions.BuiltInAction;
import net.neoforged.neoform.runtime.artifacts.Artifact;
import net.neoforged.neoform.runtime.artifacts.ArtifactManager;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import net.neoforged.neoform.runtime.graph.ResultRepresentation;
import net.neoforged.neoform.runtime.manifests.MinecraftVersionManifest;

public class DownloadFromVersionManifestAction
extends BuiltInAction {
    private final ArtifactManager artifactManager;
    private final String manifestEntry;

    public DownloadFromVersionManifestAction(ArtifactManager artifactManager, String manifestEntry) {
        this.artifactManager = artifactManager;
        this.manifestEntry = manifestEntry;
    }

    @Override
    public void run(ProcessingEnvironment environment) throws IOException, InterruptedException {
        MinecraftVersionManifest versionManifest = environment.getRequiredInput("versionManifest", ResultRepresentation.MINECRAFT_VERSION_MANIFEST);
        Artifact result = this.artifactManager.downloadFromManifest(versionManifest, this.manifestEntry);
        environment.setOutput("output", result.path());
    }

    @Override
    public void computeCacheKey(CacheKeyBuilder ck) {
        super.computeCacheKey(ck);
        ck.add("manifest entry", this.manifestEntry);
    }
}

