/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cli;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.neoforged.neoform.runtime.artifacts.ArtifactManager;
import net.neoforged.neoform.runtime.cache.CacheManager;
import net.neoforged.neoform.runtime.cache.LauncherInstallations;
import net.neoforged.neoform.runtime.cli.CacheMaintenance;
import net.neoforged.neoform.runtime.cli.CleanCacheCommand;
import net.neoforged.neoform.runtime.cli.DownloadAssetsCommand;
import net.neoforged.neoform.runtime.cli.LockManager;
import net.neoforged.neoform.runtime.cli.RunNeoFormCommand;
import net.neoforged.neoform.runtime.downloads.DownloadManager;
import net.neoforged.neoform.runtime.utils.Logger;
import net.neoforged.neoform.runtime.utils.OsUtil;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(name="neoform-runtime", subcommands={RunNeoFormCommand.class, DownloadAssetsCommand.class, CleanCacheCommand.class, CacheMaintenance.class}, mixinStandardHelpOptions=true)
public class Main {
    @CommandLine.Option(names={"--home-dir"}, scope=CommandLine.ScopeType.INHERIT, description={"Where NFRT should store caches."})
    Path homeDir = Main.getDefaultHomeDir();
    @CommandLine.Option(names={"--work-dir"}, scope=CommandLine.ScopeType.INHERIT, description={"Where temporary working directories are stored. Defaults to the subfolder 'work' in the NFRT home dir."})
    @Nullable
    Path workDir;
    @CommandLine.Option(names={"--repository"}, arity="*", scope=CommandLine.ScopeType.INHERIT, description={"Overrides Maven repositories used for downloading artifacts."})
    List<URI> repositories = List.of(URI.create("https://maven.neoforged.net/releases/"), Path.of(System.getProperty("user.home"), ".m2", "repository").toUri());
    @CommandLine.Option(names={"--add-repository"}, arity="*", scope=CommandLine.ScopeType.INHERIT, description={"Add Maven repositories for downloading artifacts."})
    List<URI> additionalRepositories = new ArrayList<URI>();
    @CommandLine.Option(names={"--launcher-dir"}, arity="*", scope=CommandLine.ScopeType.INHERIT, description={"Specifies one or more Minecraft launcher installation directories. NFRT will try to reuse files from these directories."})
    List<Path> launcherDirs = new ArrayList<Path>();
    @CommandLine.Option(names={"--artifact-manifest"}, scope=CommandLine.ScopeType.INHERIT)
    @Nullable
    Path artifactManifest;
    @CommandLine.Option(names={"--warn-on-artifact-manifest-miss"}, scope=CommandLine.ScopeType.INHERIT, description={"Warns when an artifact manifest is given, but a file is being downloaded that is not in the manifest."}, negatable=true, fallbackValue="true")
    boolean warnOnArtifactManifestMiss;
    @CommandLine.Option(names={"--launcher-meta-uri"}, scope=CommandLine.ScopeType.INHERIT)
    URI launcherManifestUrl = URI.create("https://launchermeta.mojang.com/mc/game/version_manifest_v2.json");
    @CommandLine.Option(names={"--verbose"}, description={"Enable verbose output"}, scope=CommandLine.ScopeType.INHERIT, negatable=true, fallbackValue="true")
    boolean verbose;
    @CommandLine.Option(names={"--color"}, description={"Enable color console output"}, scope=CommandLine.ScopeType.INHERIT, negatable=true, fallbackValue="true")
    boolean color = Main.shouldEnableColor();
    @CommandLine.Option(names={"--emojis"}, description={"Enable use of emojis in console output"}, scope=CommandLine.ScopeType.INHERIT, negatable=true, fallbackValue="true")
    boolean emojis = this.shouldEnableEmojis();

    private boolean shouldEnableEmojis() {
        return OsUtil.isLinux() || OsUtil.isMac();
    }

    private static boolean shouldEnableColor() {
        return System.getenv("NO_COLOR") == null || System.getenv("NO_COLOR").isEmpty();
    }

    public Path getWorkDir() {
        return Objects.requireNonNullElseGet(this.workDir, () -> this.homeDir.resolve("work"));
    }

    private static Path getDefaultHomeDir() {
        Path userHomeDir = Paths.get(System.getProperty("user.home"), new String[0]);
        if (OsUtil.isLinux()) {
            String xdgCacheHome = System.getenv("XDG_CACHE_DIR");
            if (xdgCacheHome != null && xdgCacheHome.startsWith("/")) {
                return Paths.get(xdgCacheHome, new String[0]).resolve("neoformruntime");
            }
            return userHomeDir.resolve(".cache/neoformruntime");
        }
        return userHomeDir.resolve(".neoformruntime");
    }

    public static void main(String ... args) {
        Main baseCommand = new Main();
        CommandLine commandLine = new CommandLine(baseCommand);
        commandLine.parseArgs(args);
        Logger.NO_COLOR = !baseCommand.color;
        Logger.NO_EMOJIS = !baseCommand.emojis;
        Logger.PRINT_THREAD = baseCommand.verbose;
        int exitCode = commandLine.execute(args);
        System.exit(exitCode);
    }

    public List<URI> getEffectiveRepositories() {
        ArrayList<URI> result = new ArrayList<URI>(this.repositories);
        result.addAll(this.additionalRepositories);
        return result;
    }

    public CacheManager createCacheManager() throws IOException {
        CacheManager cacheManager = new CacheManager(this.homeDir, this.getWorkDir());
        cacheManager.setVerbose(this.verbose);
        return cacheManager;
    }

    public LauncherInstallations createLauncherInstallations() {
        LauncherInstallations installations = new LauncherInstallations(this.launcherDirs);
        installations.setVerbose(this.verbose);
        return installations;
    }

    public LockManager createLockManager() throws IOException {
        LockManager lockManager = new LockManager(this.homeDir);
        lockManager.setVerbose(this.verbose);
        return lockManager;
    }

    public ArtifactManager createArtifactManager(CacheManager cacheManager, DownloadManager downloadManager, LockManager lockManager, LauncherInstallations launcherInstallations) throws IOException {
        ArtifactManager artifactManager = new ArtifactManager(this.getEffectiveRepositories(), cacheManager, downloadManager, lockManager, this.launcherManifestUrl, launcherInstallations);
        artifactManager.setWarnOnArtifactManifestMiss(this.warnOnArtifactManifestMiss);
        if (this.artifactManifest != null) {
            artifactManager.loadArtifactManifest(this.artifactManifest);
        }
        return artifactManager;
    }
}

