/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipOutputStream;
import net.neoforged.neoform.runtime.actions.ExtensibleClasspath;
import net.neoforged.neoform.runtime.actions.ExternalJavaToolAction;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import net.neoforged.neoform.runtime.utils.ToolCoordinate;
import org.jetbrains.annotations.Nullable;

public class ApplySourceTransformAction
extends ExternalJavaToolAction {
    private final ExtensibleClasspath parserClasspath = new ExtensibleClasspath();
    private List<String> accessTransformersData = new ArrayList<String>();
    private List<Path> additionalAccessTransformers = new ArrayList<Path>();
    private List<Path> injectedInterfaces = new ArrayList<Path>();
    @Nullable
    private Path parchmentData;
    private List<String> additionalArguments = new ArrayList<String>();

    public ApplySourceTransformAction() {
        super(ToolCoordinate.JAVA_SOURCE_TRANSFORMER);
    }

    @Override
    public void run(ProcessingEnvironment environment) throws IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        Collections.addAll(args, "--libraries-list", "{libraries}", "--in-format", "ARCHIVE", "--out-format", "ARCHIVE");
        if (!this.accessTransformersData.isEmpty() || !this.additionalAccessTransformers.isEmpty()) {
            args.add("--enable-accesstransformers");
            for (String dataId : this.accessTransformersData) {
                Path accessTransformers = environment.extractData(dataId);
                Stream<Path> stream = Files.walk(accessTransformers, new FileVisitOption[0]);
                try {
                    stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                        args.add("--access-transformer");
                        args.add(environment.getPathArgument((Path)path));
                    });
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            for (Path path2 : this.additionalAccessTransformers) {
                args.add("--access-transformer");
                args.add(environment.getPathArgument(path2));
            }
        }
        if (!this.injectedInterfaces.isEmpty()) {
            args.add("--enable-interface-injection");
            for (Path path2 : this.injectedInterfaces) {
                args.add("--interface-injection-data");
                args.add(environment.getPathArgument(path2.toAbsolutePath()));
            }
            args.add("--interface-injection-stubs");
            args.add("{stubs}");
        }
        if (this.parchmentData != null) {
            args.add("--enable-parchment");
            args.add("--parchment-mappings=" + environment.getPathArgument(this.parchmentData.toAbsolutePath()));
        }
        if (!this.parserClasspath.isEmpty()) {
            List<Path> classpath = environment.getArtifactManager().resolveClasspath(this.parserClasspath.getEffectiveClasspath());
            args.add("--classpath");
            args.add(classpath.stream().map(environment::getPathArgument).collect(Collectors.joining(File.pathSeparator)));
        }
        args.addAll(this.additionalArguments);
        Collections.addAll(args, "{input}", "{output}");
        this.setArgs(args);
        super.run(environment);
        if (this.injectedInterfaces.isEmpty()) {
            Path stubsPath = environment.getOutputPath("stubs");
            try {
                new ZipOutputStream(Files.newOutputStream(stubsPath, new OpenOption[0])).close();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create empty stub zip at " + String.valueOf(stubsPath), e);
            }
        }
    }

    @Override
    public void computeCacheKey(CacheKeyBuilder ck) {
        super.computeCacheKey(ck);
        ck.addStrings("access transformers data ids", this.accessTransformersData);
        ck.addPaths("additional access transformers", this.additionalAccessTransformers);
        ck.addPaths("injected interfaces", this.injectedInterfaces);
        if (this.parchmentData != null) {
            ck.addPath("parchment data", this.parchmentData);
        }
        ck.addStrings("additional arguments", this.additionalArguments);
        this.parserClasspath.computeCacheKey("parser classpath", ck);
    }

    public List<String> getAccessTransformersData() {
        return this.accessTransformersData;
    }

    public void setAccessTransformersData(List<String> accessTransformersData) {
        this.accessTransformersData = List.copyOf(accessTransformersData);
    }

    public List<Path> getAdditionalAccessTransformers() {
        return this.additionalAccessTransformers;
    }

    public void setAdditionalAccessTransformers(List<Path> additionalAccessTransformers) {
        this.additionalAccessTransformers = List.copyOf(additionalAccessTransformers);
    }

    public void setInjectedInterfaces(List<Path> injectedInterfaces) {
        this.injectedInterfaces = List.copyOf(injectedInterfaces);
    }

    @Nullable
    public Path getParchmentData() {
        return this.parchmentData;
    }

    public void setParchmentData(@Nullable Path parchmentData) {
        this.parchmentData = parchmentData;
    }

    public ExtensibleClasspath getParserClasspath() {
        return this.parserClasspath;
    }

    public List<String> getAdditionalArguments() {
        return this.additionalArguments;
    }

    public void setAdditionalArguments(List<String> additionalArguments) {
        this.additionalArguments = additionalArguments;
    }

    public void addArg(String arg) {
        this.additionalArguments.add(arg);
    }
}

