/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cli;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.neoforged.neoform.runtime.utils.HashingUtil;

public class FileHashService {
    private final Map<Path, String> hashValues = new HashMap<Path, String>();
    private final ConcurrentHashMap<Path, Lock> locks = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHashValue(Path path) throws IOException {
        Lock lock = this.locks.computeIfAbsent(path, ignored -> new ReentrantLock());
        try {
            lock.lock();
            String hashValue = this.hashValues.get(path);
            if (hashValue == null) {
                hashValue = Files.isDirectory(path, new LinkOption[0]) ? HashingUtil.hashDirectory(path, "SHA1") : HashingUtil.hashFile(path, "SHA1");
                this.hashValues.put(path, hashValue);
            }
            String string = hashValue;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHashValue(Path path, String hash) {
        Lock lock = this.locks.computeIfAbsent(path, ignored -> new ReentrantLock());
        try {
            lock.lock();
            this.hashValues.put(path, hash);
        }
        finally {
            lock.unlock();
        }
    }
}

