/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cli;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HexFormat;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import net.neoforged.neoform.runtime.artifacts.Artifact;
import net.neoforged.neoform.runtime.artifacts.ArtifactManager;
import net.neoforged.neoform.runtime.cache.CacheManager;
import net.neoforged.neoform.runtime.cli.NeoFormEngineCommand;
import net.neoforged.neoform.runtime.config.neoforge.NeoForgeConfig;
import net.neoforged.neoform.runtime.config.neoform.NeoFormConfig;
import net.neoforged.neoform.runtime.downloads.DownloadManager;
import net.neoforged.neoform.runtime.downloads.DownloadSpec;
import net.neoforged.neoform.runtime.engine.NeoFormEngine;
import net.neoforged.neoform.runtime.manifests.AssetIndex;
import net.neoforged.neoform.runtime.manifests.AssetIndexReference;
import net.neoforged.neoform.runtime.manifests.AssetObject;
import net.neoforged.neoform.runtime.manifests.MinecraftVersionManifest;
import net.neoforged.neoform.runtime.utils.Logger;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;
import net.neoforged.neoform.runtime.utils.StringUtil;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(name="download-assets", description={"Download the client assets used to run a particular game version"})
public class DownloadAssetsCommand
extends NeoFormEngineCommand {
    private static final Logger LOG = Logger.create();
    private static final ThreadFactory DOWNLOAD_THREAD_FACTORY = r -> Thread.ofVirtual().name("download-asset", 1L).unstarted(r);
    @CommandLine.ArgGroup(multiplicity="1")
    public Version version;
    @CommandLine.Option(names={"--asset-repository"})
    public URI assetRepository = URI.create("https://resources.download.minecraft.net/");
    @CommandLine.Option(names={"--concurrent-downloads"})
    public int concurrentDownloads = 25;
    @CommandLine.Option(names={"--output-properties-to"})
    public String outputPropertiesPath;

    private String getMinecraftVersion(ArtifactManager artifactManager) throws IOException {
        MavenCoordinate neoformArtifact;
        if (this.version.minecraftVersion != null) {
            return this.version.minecraftVersion;
        }
        if (this.version.neoformArtifact != null) {
            neoformArtifact = MavenCoordinate.parse(this.version.neoformArtifact);
        } else {
            Artifact neoforgeArtifact = artifactManager.get(this.version.neoforgeArtifact);
            try (JarFile neoforgeZipFile = new JarFile(neoforgeArtifact.path().toFile());){
                NeoForgeConfig neoforgeConfig = NeoForgeConfig.from(neoforgeZipFile);
                neoformArtifact = MavenCoordinate.parse(neoforgeConfig.neoformArtifact());
            }
        }
        Artifact neoFormArchive = artifactManager.get(neoformArtifact);
        try (ZipFile zipFile = new ZipFile(neoFormArchive.path().toFile());){
            String string = NeoFormConfig.from(zipFile).minecraftVersion();
            return string;
        }
    }

    @Override
    protected void runWithNeoFormEngine(NeoFormEngine engine, List<AutoCloseable> closables) throws IOException, InterruptedException {
        ArtifactManager artifactManager = engine.getArtifactManager();
        DownloadManager downloadManager = artifactManager.getDownloadManager();
        String minecraftVersion = this.getMinecraftVersion(artifactManager);
        MinecraftVersionManifest versionManifest = MinecraftVersionManifest.from(artifactManager.getVersionManifest(minecraftVersion).path());
        AssetIndexReference assetIndexReference = versionManifest.assetIndex();
        LOG.println("Downloading asset index " + assetIndexReference.id());
        CacheManager cacheManager = engine.getCacheManager();
        Path assetRoot = cacheManager.getAssetsDir();
        Path indexFolder = assetRoot.resolve("indexes");
        Files.createDirectories(indexFolder, new FileAttribute[0]);
        Path objectsFolder = assetRoot.resolve("objects");
        Files.createDirectories(objectsFolder, new FileAttribute[0]);
        Path assetIndexPath = indexFolder.resolve(assetIndexReference.id() + ".json");
        downloadManager.download(assetIndexReference, assetIndexPath);
        for (int i = 0; i < 256; ++i) {
            Path objectSubFolder = objectsFolder.resolve(HexFormat.of().toHexDigits(i, 2));
            Files.createDirectories(objectSubFolder, new FileAttribute[0]);
        }
        AtomicInteger downloadsDone = new AtomicInteger();
        AtomicLong bytesDownloaded = new AtomicLong();
        ArrayList errors = new ArrayList();
        AssetIndex assetIndex = AssetIndex.from(assetIndexPath);
        List<AssetObject> objectsToDownload = assetIndex.objects().values().stream().distinct().filter(obj -> Files.notExists(objectsFolder.resolve(DownloadAssetsCommand.getObjectPath(obj)), new LinkOption[0])).toList();
        if (this.concurrentDownloads < 1) {
            throw new IllegalStateException("Cannot set concurrent downloads to less than 1: " + this.concurrentDownloads);
        }
        Semaphore semaphore = new Semaphore(this.concurrentDownloads);
        try (ExecutorService executor = Executors.newThreadPerTaskExecutor(DOWNLOAD_THREAD_FACTORY);){
            for (AssetObject object : objectsToDownload) {
                AssetDownloadSpec spec = new AssetDownloadSpec(object);
                String objectHash = object.hash();
                String objectPath = objectHash.substring(0, 2) + "/" + objectHash;
                Path objectLocation = objectsFolder.resolve(objectPath);
                executor.execute(() -> {
                    boolean hasAcquired = false;
                    try {
                        semaphore.acquire();
                        hasAcquired = true;
                        if (downloadManager.download(spec, objectLocation, true)) {
                            bytesDownloaded.addAndGet(spec.size());
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        ArrayList arrayList = errors;
                        synchronized (arrayList) {
                            errors.add(e);
                        }
                    }
                    finally {
                        int finished;
                        if (hasAcquired) {
                            semaphore.release();
                        }
                        if ((finished = downloadsDone.incrementAndGet()) % 100 == 0) {
                            LOG.println(finished + "/" + objectsToDownload.size() + " downloads");
                        }
                    }
                });
            }
        }
        LOG.println("Downloaded " + objectsToDownload.size() + " assets with a total size of " + StringUtil.formatBytes(bytesDownloaded.get()));
        if (!errors.isEmpty()) {
            System.err.println(errors.size() + " files failed to download");
            System.err.println("First error:");
            ((Exception)errors.getFirst()).printStackTrace();
            System.exit(1);
        }
        if (this.outputPropertiesPath != null) {
            Properties properties = new Properties();
            properties.put("assets_root", assetRoot.toAbsolutePath().toString());
            properties.put("asset_index", assetIndexReference.id());
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(Paths.get(this.outputPropertiesPath, new String[0]), new OpenOption[0]));){
                properties.store(out, null);
            }
        }
    }

    private static String getObjectPath(AssetObject object) {
        String objectHash = object.hash();
        return objectHash.substring(0, 2) + "/" + objectHash;
    }

    public static class Version {
        @CommandLine.Option(names={"--minecraft-version"})
        String minecraftVersion;
        @CommandLine.Option(names={"--neoform"})
        String neoformArtifact;
        @CommandLine.Option(names={"--neoforge"})
        String neoforgeArtifact;
    }

    private class AssetDownloadSpec
    implements DownloadSpec {
        private final AssetObject object;

        public AssetDownloadSpec(AssetObject object) {
            this.object = object;
        }

        @Override
        public URI uri() {
            return URI.create(DownloadAssetsCommand.this.assetRepository.toString() + DownloadAssetsCommand.getObjectPath(this.object));
        }

        @Override
        public int size() {
            return this.object.size();
        }

        @Override
        @Nullable
        public String checksum() {
            return this.object.hash();
        }

        @Override
        @Nullable
        public String checksumAlgorithm() {
            return "SHA1";
        }
    }
}

