/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import net.neoforged.neoform.runtime.actions.BuiltInAction;
import net.neoforged.neoform.runtime.actions.RecompileSourcesAction;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;

public class RecompileSourcesActionWithJDK
extends RecompileSourcesAction {
    private final List<String> compilerOptions = new ArrayList<String>();

    public RecompileSourcesActionWithJDK() {
        this.compilerOptions.add("--release");
        this.compilerOptions.add("21");
        this.compilerOptions.add("-proc:none");
        this.compilerOptions.add("-nowarn");
        this.compilerOptions.add("-g");
        this.compilerOptions.add("-XDuseUnsharedTable=true");
    }

    @Override
    public void run(final ProcessingEnvironment environment) throws IOException, InterruptedException {
        Path sources = environment.getRequiredInputPath("sources");
        List<Path> classpath = this.getEffectiveClasspath(environment);
        URI uri = URI.create("jar:" + String.valueOf(sources.toUri()));
        try (FileSystem sourceFs = FileSystems.newFileSystem(uri, Map.of());){
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            Path sourceRoot = sourceFs.getRootDirectories().iterator().next();
            ArrayList sourcePaths = new ArrayList();
            ArrayList nonSourcePaths = new ArrayList();
            try (Stream<Path> stream = Files.walk(sourceRoot, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
                stream.forEach(path -> {
                    String filename = path.getFileName().toString();
                    if (filename.endsWith(".java")) {
                        sourcePaths.add(path);
                    } else {
                        nonSourcePaths.add(path);
                    }
                });
            }
            LOG.println(" Compiling " + sourcePaths.size() + " source files");
            DiagnosticListener<JavaFileObject> diagnostics = new DiagnosticListener<JavaFileObject>(){

                @Override
                public void report(Diagnostic<? extends JavaFileObject> d) {
                    if (!environment.isVerbose() && d.getKind() != Diagnostic.Kind.ERROR) {
                        return;
                    }
                    String location = d.getSource() != null ? d.getSource().getName() : "<unknown>";
                    BuiltInAction.LOG.println(" " + String.valueOf((Object)d.getKind()) + " Line: " + d.getLineNumber() + ", " + d.getMessage(null) + " in " + location);
                }
            };
            Path outputPath = environment.getOutputPath("output");
            try (FileSystem outputFs = FileSystems.newFileSystem(URI.create("jar:" + String.valueOf(outputPath.toUri())), Map.of("create", true));){
                Path outputRoot = outputFs.getRootDirectories().iterator().next();
                try (StandardJavaFileManager fileManager = compiler.getStandardFileManager((DiagnosticListener<? super JavaFileObject>)diagnostics, Locale.ROOT, StandardCharsets.UTF_8);){
                    fileManager.setLocationFromPaths(StandardLocation.CLASS_OUTPUT, Collections.singleton(outputRoot));
                    fileManager.setLocationFromPaths(StandardLocation.CLASS_PATH, classpath);
                    Iterable<? extends JavaFileObject> sourceJavaFiles = fileManager.getJavaFileObjectsFromPaths(sourcePaths);
                    JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, (DiagnosticListener<? super JavaFileObject>)diagnostics, this.compilerOptions, null, sourceJavaFiles);
                    if (!task.call().booleanValue()) {
                        throw new IOException("Compilation failed");
                    }
                }
                for (Path nonSourcePath : nonSourcePaths) {
                    String relativeDestinationPath = sourceRoot.relativize(nonSourcePath).toString().replace('\\', '/');
                    Path destination = outputRoot.resolve(relativeDestinationPath);
                    Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                    Files.copy(nonSourcePath, destination, new CopyOption[0]);
                }
                LOG.println("Copied " + nonSourcePaths.size() + " resource files");
            }
        }
    }

    @Override
    public void computeCacheKey(CacheKeyBuilder ck) {
        super.computeCacheKey(ck);
        ck.add("compiler type", "javac");
        ck.addStrings("compiler options", this.compilerOptions);
    }
}

