/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.neoforged.neoform.runtime.actions.BuiltInAction;
import net.neoforged.neoform.runtime.actions.RecompileSourcesAction;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.ClasspathMultiReleaseJar;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.util.Util;

public class RecompileSourcesActionWithECJ
extends RecompileSourcesAction {
    @Override
    public void run(ProcessingEnvironment environment) throws IOException, InterruptedException {
        ICompilationUnit[] compilationUnits;
        Compiler compiler;
        Path sources = environment.getRequiredInputPath("sources");
        List<Path> classpathPaths = this.getEffectiveClasspath(environment);
        ArrayList<ClasspathMultiReleaseJar> classpaths = new ArrayList<ClasspathMultiReleaseJar>();
        Util.collectRunningVMBootclasspath(classpaths);
        for (Path library : classpathPaths) {
            classpaths.add(new ClasspathMultiReleaseJar(library.toFile(), true, new AccessRuleSet(new AccessRule[0], 0, library.getFileName().toString()), "none", "21"));
        }
        ECJFilesystem nameEnvironment = new ECJFilesystem((FileSystem.Classpath[])classpaths.toArray(FileSystem.Classpath[]::new), new String[0], false);
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.exitOnFirstError();
        CompilerOptions options = new CompilerOptions(Map.of("org.eclipse.jdt.core.compiler.source", "21", "org.eclipse.jdt.core.compiler.compliance", "21", "org.eclipse.jdt.core.compiler.codegen.targetPlatform", "21", "org.eclipse.jdt.core.compiler.problem.deprecation", "ignore", "org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled", "org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "disabled", "org.eclipse.jdt.core.compiler.debug.localVariable", "generate", "org.eclipse.jdt.core.compiler.debug.lineNumber", "generate", "org.eclipse.jdt.core.compiler.debug.sourceFile", "generate"));
        options.performMethodsFullRecovery = false;
        options.performStatementsRecovery = false;
        options.processAnnotations = false;
        options.suppressWarnings = true;
        final Compiler[] compilerRef = new Compiler[1];
        var requestor = new ICompilerRequestor(){
            final Map<String, byte[]> classFileContent = new ConcurrentHashMap<String, byte[]>();
            AtomicLong totalSize = new AtomicLong();

            public void acceptResult(CompilationResult result) {
                if (result.hasErrors()) {
                    System.err.println("ERRORS FOUND in " + new String(result.compilationUnit.getFileName()));
                    for (ClassFile classFile : result.getErrors()) {
                        BuiltInAction.LOG.println("ERROR: " + String.valueOf(classFile));
                    }
                }
                for (ClassFile classFile : result.getClassFiles()) {
                    byte[] bytes = classFile.getBytes();
                    this.classFileContent.put(new String(classFile.fileName()) + ".class", bytes);
                    this.totalSize.addAndGet(bytes.length);
                }
                compilerRef[0].lookupEnvironment.releaseClassFiles(result.getClassFiles());
            }
        };
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.ROOT);
        compilerRef[0] = compiler = new Compiler((INameEnvironment)nameEnvironment, policy, options, requestor, (IProblemFactory)problemFactory);
        compiler.useSingleThread = false;
        HashMap<String, byte[]> nonSourceContent = new HashMap<String, byte[]>();
        try (ZipFile sourcesZip = new ZipFile(sources.toFile());
             ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
            ArrayList<Future<ICompilationUnit>> futures = new ArrayList<Future<ICompilationUnit>>();
            Enumeration<? extends ZipEntry> entries = sourcesZip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                if (entry.getName().endsWith(".java")) {
                    futures.add(executor.submit(() -> {
                        try (InputStream in = sourcesZip.getInputStream(entry);){
                            char[] contents = new String(in.readAllBytes(), StandardCharsets.UTF_8).toCharArray();
                            CompilationUnit compilationUnit = new CompilationUnit(contents, entry.getName().replace('\\', '/'), "UTF-8");
                            return compilationUnit;
                        }
                    }));
                    continue;
                }
                InputStream inputStream = sourcesZip.getInputStream(entry);
                try {
                    nonSourceContent.put(entry.getName(), inputStream.readAllBytes());
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            compilationUnits = new ICompilationUnit[futures.size()];
            for (int i = 0; i < futures.size(); ++i) {
                Future future = (Future)futures.get(i);
                try {
                    compilationUnits[i] = (ICompilationUnit)future.get();
                    continue;
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof RuntimeException) {
                        RuntimeException runtimeCause = (RuntimeException)throwable;
                        throw runtimeCause;
                    }
                    throw new RuntimeException(e.getCause());
                }
            }
        }
        LOG.println("Compiling " + compilationUnits.length + " source files...");
        compiler.compile(compilationUnits);
        LOG.println("Wrote " + requestor.classFileContent.size() + " class files (" + requestor.totalSize.get() + " bytes total)");
        Path outputPath = environment.getOutputPath("output");
        try (OutputStream fileOut = Files.newOutputStream(outputPath, new OpenOption[0]);
             JarOutputStream jos = new JarOutputStream(fileOut);){
            ArrayList<String> keys = new ArrayList<String>(requestor.classFileContent.keySet());
            keys.sort(Comparator.naturalOrder());
            for (String string : keys) {
                byte[] content = requestor.classFileContent.get(string);
                JarEntry entry = new JarEntry(string);
                jos.putNextEntry(entry);
                jos.write(content);
                jos.closeEntry();
            }
            for (Map.Entry entry : nonSourceContent.entrySet()) {
                JarEntry jarEntry = new JarEntry((String)entry.getKey());
                jos.putNextEntry(jarEntry);
                jos.write((byte[])entry.getValue());
                jos.closeEntry();
            }
            LOG.println("Copied " + nonSourceContent.size() + " resource files");
        }
    }

    @Override
    public void computeCacheKey(CacheKeyBuilder ck) {
        super.computeCacheKey(ck);
        ck.add("compiler type", "eclipse");
    }

    static class ECJFilesystem
    extends FileSystem {
        protected ECJFilesystem(FileSystem.Classpath[] paths, String[] initialFileNames, boolean annotationsFromClasspath) {
            super(paths, initialFileNames, annotationsFromClasspath);
        }
    }
}

