/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import net.neoforged.neoform.runtime.actions.BuiltInAction;
import net.neoforged.neoform.runtime.actions.ExtensibleClasspath;
import net.neoforged.neoform.runtime.artifacts.ClasspathItem;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import net.neoforged.neoform.runtime.graph.ExecutionNodeAction;
import net.neoforged.neoform.runtime.graph.ResultRepresentation;
import net.neoforged.neoform.runtime.manifests.MinecraftVersionManifest;

public abstract class RecompileSourcesAction
extends BuiltInAction
implements ExecutionNodeAction {
    private final ExtensibleClasspath classpath = new ExtensibleClasspath();

    @Override
    public void computeCacheKey(CacheKeyBuilder ck) {
        super.computeCacheKey(ck);
        this.classpath.computeCacheKey("compile classpath", ck);
    }

    protected final List<Path> getEffectiveClasspath(ProcessingEnvironment environment) throws IOException {
        MinecraftVersionManifest versionManifest = environment.getRequiredInput("versionManifest", ResultRepresentation.MINECRAFT_VERSION_MANIFEST);
        ExtensibleClasspath effectiveClasspath = this.classpath.copy();
        effectiveClasspath.addMinecraftLibraries(versionManifest.libraries());
        List<ClasspathItem> effectiveClasspathItems = effectiveClasspath.getEffectiveClasspath();
        List<Path> classpath = environment.getArtifactManager().resolveClasspath(effectiveClasspathItems);
        LOG.println(" " + classpath.size() + " items on the compile classpath");
        return classpath;
    }

    public ExtensibleClasspath getClasspath() {
        return this.classpath;
    }
}

