/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.neoforged.neoform.runtime.actions.ExternalJavaToolAction;
import net.neoforged.neoform.runtime.graph.ExecutionNodeBuilder;
import net.neoforged.neoform.runtime.graph.NodeOutput;
import net.neoforged.neoform.runtime.graph.NodeOutputType;
import net.neoforged.neoform.runtime.utils.ToolCoordinate;

public final class PatchActionFactory {
    public static NodeOutput makeAction(ExecutionNodeBuilder builder, Path patchesArchive, String sourcePathInArchive, NodeOutput sources) {
        String patchesInZip = Objects.requireNonNull(sourcePathInArchive, "patches");
        builder.input("input", sources.asInput());
        NodeOutput mainOutput = builder.output("output", NodeOutputType.ZIP, "ZIP file containing the patched sources");
        builder.output("outputRejects", NodeOutputType.ZIP, "ZIP file containing the rejected patches");
        ExternalJavaToolAction action = new ExternalJavaToolAction(ToolCoordinate.DIFF_PATCH);
        action.setArgs(List.of("{input}", patchesArchive.toString(), "--prefix", patchesInZip, "--patch", "--archive", "ZIP", "--output", "{output}", "--log-level", "WARN", "--mode", "OFFSET", "--archive-rejects", "ZIP", "--reject", "{outputRejects}"));
        builder.action(action);
        return mainOutput;
    }
}

