/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HexFormat;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.neoforged.neoform.runtime.actions.InjectSource;
import net.neoforged.neoform.runtime.cache.CacheKey;
import net.neoforged.neoform.runtime.cli.FileHashService;
import org.jetbrains.annotations.Nullable;

public class InjectFromZipFileSource
implements InjectSource {
    private final ZipFile zf;
    private final String sourcePath;

    public InjectFromZipFileSource(ZipFile zf, String sourcePath) {
        this.zf = zf;
        this.sourcePath = InjectFromZipFileSource.sanitizeSourcePath(sourcePath);
    }

    private static String sanitizeSourcePath(String sourcePath) {
        while (((String)sourcePath).startsWith("/")) {
            sourcePath = ((String)sourcePath).substring(1);
        }
        if (!((String)sourcePath).isEmpty() && !((String)sourcePath).endsWith("/")) {
            sourcePath = (String)sourcePath + "/";
        }
        return sourcePath;
    }

    @Override
    public CacheKey.AnnotatedValue getCacheKey(FileHashService fileHashService) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        DigestOutputStream digestStream = new DigestOutputStream(OutputStream.nullOutputStream(), digest);
        Enumeration<? extends ZipEntry> entries = this.zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!this.sourcePath.isEmpty() && !entry.getName().startsWith(this.sourcePath)) continue;
            digestStream.write(entry.getName().getBytes());
            InputStream in = this.zf.getInputStream(entry);
            try {
                in.transferTo(digestStream);
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
        return new CacheKey.AnnotatedValue(HexFormat.of().formatHex(digest.digest()), this.sourcePath + " from " + this.zf.getName());
    }

    @Override
    public byte @Nullable [] tryReadFile(String path) throws IOException {
        ZipEntry entry = this.zf.getEntry(this.sourcePath + path);
        if (entry != null) {
            try (InputStream in = this.zf.getInputStream(entry);){
                byte[] byArray = in.readAllBytes();
                return byArray;
            }
        }
        return null;
    }

    @Override
    public void copyTo(ZipOutputStream out) throws IOException {
        Enumeration<? extends ZipEntry> entries = this.zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!this.sourcePath.isEmpty() && !entry.getName().startsWith(this.sourcePath)) continue;
            try {
                InputStream in = this.zf.getInputStream(entry);
                try {
                    ZipEntry copiedEntry = new ZipEntry(entry.getName().substring(this.sourcePath.length()));
                    if (copiedEntry.getName().isEmpty()) continue;
                    copiedEntry.setMethod(entry.getMethod());
                    out.putNextEntry(copiedEntry);
                    in.transferTo(out);
                    out.closeEntry();
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (ZipException e) {
                if (!e.getMessage().startsWith("duplicate entry:")) {
                    throw e;
                }
                if (entry.isDirectory()) continue;
                System.err.println("Cannot inject duplicate file " + entry.getName());
            }
        }
    }
}

