/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.neoforged.neoform.runtime.artifacts.Artifact;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import net.neoforged.neoform.runtime.graph.ExecutionNodeAction;
import net.neoforged.neoform.runtime.utils.AnsiColor;
import net.neoforged.neoform.runtime.utils.Logger;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;
import net.neoforged.neoform.runtime.utils.ToolCoordinate;
import org.jetbrains.annotations.Nullable;

public class ExternalJavaToolAction
implements ExecutionNodeAction {
    private static final Logger LOG = Logger.create();
    private MavenCoordinate toolArtifactId;
    @Nullable
    private URI repositoryUrl;
    private List<String> jvmArgs = new ArrayList<String>();
    private List<String> args = new ArrayList<String>();

    public ExternalJavaToolAction(MavenCoordinate toolArtifactId) {
        this.toolArtifactId = toolArtifactId;
    }

    public ExternalJavaToolAction(ToolCoordinate toolCoordinate) {
        this.toolArtifactId = toolCoordinate.version();
    }

    @Override
    public void run(ProcessingEnvironment environment) throws IOException, InterruptedException {
        Artifact toolArtifact = this.repositoryUrl != null ? environment.getArtifactManager().get(this.toolArtifactId, this.repositoryUrl) : environment.getArtifactManager().get(this.toolArtifactId);
        String javaExecutablePath = ProcessHandle.current().info().command().orElseThrow();
        Path workingDir = environment.getWorkspace();
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaExecutablePath);
        for (String jvmArg : this.jvmArgs) {
            command.add(environment.interpolateString(jvmArg));
        }
        command.add("-jar");
        command.add(environment.getPathArgument(toolArtifact.path()));
        for (String arg : this.args) {
            if (this.toolArtifactId.groupId().equals("org.vineflower") && this.toolArtifactId.artifactId().equals("vineflower")) {
                arg = arg.replace("TRACE", "WARN");
            }
            command.add(environment.interpolateString(arg));
        }
        LOG.println(" \u21b3 Running external tool " + String.valueOf(this.toolArtifactId));
        if (environment.isVerbose()) {
            LOG.println(" " + String.valueOf((Object)AnsiColor.MUTED) + ExternalJavaToolAction.printableCommand(command) + String.valueOf((Object)AnsiColor.RESET));
        }
        File logFile = workingDir.resolve("console_output.txt").toFile();
        Process process = new ProcessBuilder(new String[0]).directory(workingDir.toFile()).command(command).redirectErrorStream(true).redirectOutput(logFile).start();
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            this.tailLogFile(logFile);
            throw new RuntimeException("Failed to execute tool");
        }
    }

    private static String printableCommand(List<String> command) {
        return command.stream().map(arg -> {
            if (arg.contains("\"")) {
                return "\"" + arg + "\"";
            }
            return arg;
        }).collect(Collectors.joining(" "));
    }

    private void tailLogFile(File logFile) {
        System.err.println("Last lines of " + String.valueOf(logFile) + ":");
        System.err.println("------------------------------------------------------------");
        try (RandomAccessFile raf = new RandomAccessFile(logFile, "r");){
            raf.seek(raf.length() - 1L);
            int bytesRead = 0;
            int linesRead = 0;
            while (raf.getFilePointer() >= 0L && raf.getFilePointer() < raf.length() && bytesRead < 2048 && linesRead < 30) {
                byte b = raf.readByte();
                ++bytesRead;
                if (b == 10) {
                    ++linesRead;
                }
                raf.seek(raf.getFilePointer() - 2L);
            }
            long toRead = raf.length() - raf.getFilePointer();
            byte[] data = new byte[(int)toRead];
            raf.readFully(data);
            System.err.println(new String(data, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            System.err.println("Failed to tail log-file " + String.valueOf(logFile));
        }
        System.err.println("------------------------------------------------------------");
    }

    @Override
    public void computeCacheKey(CacheKeyBuilder ck) {
        ck.add("external tool", this.toolArtifactId.toString());
        if (this.repositoryUrl != null) {
            ck.add("external tool repository", this.repositoryUrl.toString());
        }
        ck.add("command line arg", String.join((CharSequence)" ", this.args));
        ck.add("jvm args", String.join((CharSequence)" ", this.jvmArgs));
    }

    public MavenCoordinate getToolArtifactId() {
        return this.toolArtifactId;
    }

    public void setToolArtifactId(MavenCoordinate toolArtifactId) {
        this.toolArtifactId = Objects.requireNonNull(toolArtifactId);
    }

    @Nullable
    public URI getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public void setRepositoryUrl(@Nullable URI repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public void setJvmArgs(List<String> jvmArgs) {
        this.jvmArgs = Objects.requireNonNull(jvmArgs);
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = Objects.requireNonNull(args);
    }
}

