/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import net.neoforged.neoform.runtime.actions.BuiltInAction;
import net.neoforged.neoform.runtime.actions.ExtensibleClasspath;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import net.neoforged.neoform.runtime.graph.ExecutionNodeAction;
import net.neoforged.neoform.runtime.graph.ResultRepresentation;
import net.neoforged.neoform.runtime.manifests.MinecraftVersionManifest;

public class CreateLibrariesOptionsFileAction
extends BuiltInAction
implements ExecutionNodeAction {
    private final ExtensibleClasspath classpath = new ExtensibleClasspath();

    @Override
    public void run(ProcessingEnvironment environment) throws IOException, InterruptedException {
        MinecraftVersionManifest versionManifest = environment.getRequiredInput("versionManifest", ResultRepresentation.MINECRAFT_VERSION_MANIFEST);
        ExtensibleClasspath effectiveClasspath = this.classpath.copy();
        effectiveClasspath.addMinecraftLibraries(versionManifest.libraries());
        List<Path> classpath = environment.getArtifactManager().resolveClasspath(effectiveClasspath.getEffectiveClasspath());
        List<String> vineflowerArgs = classpath.stream().map(l -> "-e=" + String.valueOf(l.toAbsolutePath())).toList();
        Path libraryListFile = environment.getOutputPath("output");
        Files.write(libraryListFile, vineflowerArgs, new OpenOption[0]);
    }

    @Override
    public void computeCacheKey(CacheKeyBuilder ck) {
        super.computeCacheKey(ck);
        this.classpath.computeCacheKey("compile classpath", ck);
    }

    public ExtensibleClasspath getClasspath() {
        return this.classpath;
    }
}

