/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.downloads;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.neoforged.neoform.runtime.downloads.DownloadSpec;
import net.neoforged.neoform.runtime.downloads.SimpleDownloadSpec;
import net.neoforged.neoform.runtime.utils.FileUtil;
import net.neoforged.neoform.runtime.utils.HashingUtil;
import net.neoforged.neoform.runtime.utils.Logger;

public class DownloadManager
implements AutoCloseable {
    private static final Logger LOG = Logger.create();
    private static final String USER_AGENT = "NeoFormRuntime";
    private final ExecutorService executor = Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("download", 1L).factory());
    private final HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).build();

    @Override
    public void close() throws Exception {
        this.httpClient.close();
        this.executor.shutdownNow();
        this.executor.awaitTermination(1L, TimeUnit.MINUTES);
    }

    public void download(URI uri, Path finalLocation) throws IOException {
        this.download(new SimpleDownloadSpec(uri), finalLocation);
    }

    public void download(DownloadSpec spec, Path finalLocation) throws IOException {
        this.download(spec, finalLocation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download(DownloadSpec spec, Path finalLocation, boolean silent) throws IOException {
        Path fileInRepo;
        String currentHash;
        URI url = spec.uri();
        if (!silent) {
            LOG.println("  \u2193 " + String.valueOf(url));
        }
        String checksum = spec.checksum();
        String checksumAlgorithm = spec.checksumAlgorithm();
        if (checksum != null && spec.checksumAlgorithm() != null && Files.exists(finalLocation, new LinkOption[0]) && checksum.equalsIgnoreCase(currentHash = HashingUtil.hashFile(finalLocation, spec.checksumAlgorithm()))) {
            return false;
        }
        Path partialFile = finalLocation.resolveSibling(String.valueOf(finalLocation.getFileName()) + "." + Math.random() + ".dltmp");
        Files.createDirectories(partialFile.getParent(), new FileAttribute[0]);
        if (url.getScheme().equals("file") && !Files.exists(fileInRepo = Path.of(url), new LinkOption[0])) {
            throw new FileNotFoundException("Could not find: " + String.valueOf(url));
        }
        try {
            if (url.getScheme().equals("file")) {
                fileInRepo = Path.of(url);
                if (!Files.exists(fileInRepo, new LinkOption[0])) {
                    throw new FileNotFoundException("Could not find: " + String.valueOf(url));
                }
                Files.copy(fileInRepo, partialFile, StandardCopyOption.REPLACE_EXISTING);
            } else {
                String fileChecksum;
                long fileSize;
                HttpRequest request = HttpRequest.newBuilder(url).header("User-Agent", USER_AGENT).build();
                int attempts = 0;
                IOException lastError = null;
                while (attempts++ < 5) {
                    HttpResponse<Path> response;
                    try {
                        response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofFile(partialFile));
                        lastError = null;
                    }
                    catch (IOException e) {
                        lastError = e;
                        DownloadManager.waitForRetry(1);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IOException("Download interrupted", e);
                    }
                    if (response.statusCode() == 200) break;
                    if (response.statusCode() == 404) {
                        throw new FileNotFoundException(url.toString());
                    }
                    lastError = new IOException("Failed to download " + String.valueOf(url) + ": " + response.statusCode());
                    if (!DownloadManager.canRetryStatusCode(response.statusCode())) break;
                    DownloadManager.waitForRetry(response);
                }
                if (lastError != null) {
                    throw lastError;
                }
                if (spec.size() != -1 && (fileSize = Files.size(partialFile)) != (long)spec.size()) {
                    throw new IOException("Size of downloaded file has unexpected size. (actual: " + fileSize + ", expected: " + spec.size() + ")");
                }
                if (checksumAlgorithm != null && checksum != null && !checksum.equalsIgnoreCase(fileChecksum = HashingUtil.hashFile(partialFile, checksumAlgorithm))) {
                    throw new IOException("Downloaded file has unexpected checksum. (actual: " + fileChecksum + ", expected: " + checksum + ")");
                }
            }
            FileUtil.atomicMove(partialFile, finalLocation);
        }
        finally {
            try {
                Files.deleteIfExists(partialFile);
            }
            catch (IOException e) {
                System.err.println("Failed to delete temporary download file " + String.valueOf(partialFile));
            }
        }
        return true;
    }

    private static void waitForRetry(HttpResponse<?> response) throws IOException {
        long retryAfter = response.headers().firstValueAsLong("Retry-After").orElse(5L);
        DownloadManager.waitForRetry(Math.clamp(retryAfter, 0, 300));
    }

    private static void waitForRetry(int seconds) throws IOException {
        Instant waitUntil = Instant.now().plusSeconds(seconds);
        while (Instant.now().isBefore(waitUntil)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while waiting for retry.", e);
            }
        }
    }

    private static boolean canRetryStatusCode(int statusCode) {
        return statusCode == 408 || statusCode == 425 || statusCode == 429 || statusCode == 502 || statusCode == 503 || statusCode == 504;
    }
}

