/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.neoforged.neoform.runtime.actions.BuiltInAction;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;

public final class SplitResourcesFromClassesAction
extends BuiltInAction {
    private final List<Pattern> denyListPatterns = new ArrayList<Pattern>();

    @Override
    public void run(ProcessingEnvironment environment) throws IOException, InterruptedException {
        Path inputJar = environment.getRequiredInputPath("input");
        Path classesJar = environment.getOutputPath("output");
        Path resourcesJar = environment.getOutputPath("resourcesOutput");
        Predicate<String> denyPredicate = s -> false;
        if (!this.denyListPatterns.isEmpty()) {
            denyPredicate = Pattern.compile(this.denyListPatterns.stream().map(Pattern::pattern).collect(Collectors.joining("|"))).asMatchPredicate();
        }
        try (JarInputStream is = new JarInputStream(new BufferedInputStream(Files.newInputStream(inputJar, new OpenOption[0])));
             BufferedOutputStream classesFileOut = new BufferedOutputStream(Files.newOutputStream(classesJar, new OpenOption[0]));
             BufferedOutputStream resourcesFileOut = new BufferedOutputStream(Files.newOutputStream(resourcesJar, new OpenOption[0]));
             JarOutputStream classesJarOut = new JarOutputStream(classesFileOut);
             JarOutputStream resourcesJarOut = new JarOutputStream(resourcesFileOut);){
            JarEntry entry;
            while ((entry = is.getNextJarEntry()) != null) {
                String filename;
                if (entry.isDirectory() || denyPredicate.test(filename = entry.getName())) continue;
                JarOutputStream destinationStream = filename.endsWith(".class") ? classesJarOut : resourcesJarOut;
                destinationStream.putNextEntry(entry);
                is.transferTo(destinationStream);
                destinationStream.closeEntry();
            }
        }
    }

    public void addDenyPatterns(String ... patterns) {
        for (String pattern : patterns) {
            this.denyListPatterns.add(Pattern.compile(pattern));
        }
    }

    @Override
    public void computeCacheKey(CacheKeyBuilder ck) {
        super.computeCacheKey(ck);
        ck.addStrings("deny patterns", this.denyListPatterns.stream().map(Pattern::pattern).toList());
    }
}

