/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.neoforged.neoform.runtime.actions.BuiltInAction;
import net.neoforged.neoform.runtime.actions.InjectSource;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import org.jetbrains.annotations.Nullable;

public class InjectZipContentAction
extends BuiltInAction {
    private List<InjectSource> injectedSources;

    public InjectZipContentAction(List<InjectSource> injectedSources) {
        this.injectedSources = new ArrayList<InjectSource>(injectedSources);
    }

    public List<InjectSource> getInjectedSources() {
        return this.injectedSources;
    }

    public void setInjectedSources(List<InjectSource> injectedSources) {
        this.injectedSources = new ArrayList<InjectSource>((Collection)Objects.requireNonNull(injectedSources));
    }

    @Override
    public void run(ProcessingEnvironment environment) throws IOException, InterruptedException {
        Path inputZipFile = environment.getRequiredInputPath("input");
        Path outputZipFile = environment.getOutputPath("output");
        String packageInfoTemplateContent = this.findPackageInfoTemplate(this.injectedSources);
        try (OutputStream fileOut = Files.newOutputStream(outputZipFile, new OpenOption[0]);
             ZipOutputStream zos = new ZipOutputStream(fileOut);){
            this.copyInputZipContent(inputZipFile, zos, packageInfoTemplateContent);
            for (InjectSource injectedSource : this.injectedSources) {
                injectedSource.copyTo(zos);
            }
        }
    }

    @Nullable
    private String findPackageInfoTemplate(List<InjectSource> injectedSources) throws IOException {
        for (InjectSource injectedSource : injectedSources) {
            byte[] content = injectedSource.tryReadFile("package-info-template.java");
            if (content == null) continue;
            return new String(content, StandardCharsets.UTF_8);
        }
        return null;
    }

    private void copyInputZipContent(Path inputZipFile, ZipOutputStream zos, @Nullable String packageInfoTemplateContent) throws IOException {
        HashSet<String> visited = new HashSet<String>();
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(inputZipFile, new OpenOption[0]));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String pkg;
                zos.putNextEntry(entry);
                zis.transferTo(zos);
                zos.closeEntry();
                if (packageInfoTemplateContent == null || !visited.add(pkg = entry.isDirectory() && !entry.getName().endsWith("/") ? entry.getName() : (entry.getName().indexOf(47) == -1 ? "" : entry.getName().substring(0, entry.getName().lastIndexOf(47)))) || !pkg.startsWith("net/minecraft/") && !pkg.startsWith("com/mojang/")) continue;
                zos.putNextEntry(new ZipEntry(pkg + "/package-info.java"));
                zos.write(packageInfoTemplateContent.replace("{PACKAGE}", pkg.replaceAll("/", ".")).getBytes(StandardCharsets.UTF_8));
                zos.closeEntry();
            }
        }
    }

    @Override
    public void computeCacheKey(CacheKeyBuilder ck) {
        super.computeCacheKey(ck);
        for (int i = 0; i < this.injectedSources.size(); ++i) {
            InjectSource injectedSource = this.injectedSources.get(i);
            try {
                ck.add("injectSource[" + i + "].type", injectedSource.getClass().getName());
                ck.add("injectSource[" + i + "].cache-key", injectedSource.getCacheKey(ck.getFileHashService()));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

