/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.neoforged.neoform.runtime.artifacts.ClasspathItem;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.manifests.MinecraftDownload;
import net.neoforged.neoform.runtime.manifests.MinecraftLibrary;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;
import org.jetbrains.annotations.Nullable;

public class ExtensibleClasspath {
    private List<ClasspathItem> additionalClasspath = new ArrayList<ClasspathItem>();
    @Nullable
    private List<ClasspathItem> overriddenClasspath;

    public List<ClasspathItem> getEffectiveClasspath() {
        if (this.overriddenClasspath != null) {
            return this.overriddenClasspath;
        }
        return List.copyOf(this.additionalClasspath);
    }

    public void addMinecraftLibraries(Collection<MinecraftLibrary> libraries) {
        for (MinecraftLibrary library : libraries) {
            if (!library.rulesMatch() || library.getArtifactDownload() == null) continue;
            this.add(ClasspathItem.of(library));
        }
    }

    public void addMavenLibraries(Collection<MavenCoordinate> additionalLibraries) {
        for (MavenCoordinate library : additionalLibraries) {
            this.add(ClasspathItem.of(library));
        }
    }

    public void addPaths(Collection<Path> additionalPaths) {
        for (Path path : additionalPaths) {
            this.add(ClasspathItem.of(path));
        }
    }

    public void add(ClasspathItem classpathItem) {
        this.additionalClasspath.add(classpathItem);
    }

    public List<ClasspathItem> getAdditionalClasspath() {
        return this.additionalClasspath;
    }

    public void setAdditionalClasspath(List<ClasspathItem> additionalClasspath) {
        this.additionalClasspath = new ArrayList<ClasspathItem>((Collection)Objects.requireNonNull(additionalClasspath, "additionalClasspath"));
    }

    @Nullable
    public List<ClasspathItem> getOverriddenClasspath() {
        return this.overriddenClasspath;
    }

    public void setOverriddenClasspath(@Nullable List<ClasspathItem> overriddenClasspath) {
        this.overriddenClasspath = overriddenClasspath != null ? List.copyOf(overriddenClasspath) : null;
    }

    /*
     * Loose catch block
     */
    public void computeCacheKey(String prefix, CacheKeyBuilder ck) {
        List<ClasspathItem> effectiveItems;
        if (this.overriddenClasspath != null) {
            effectiveItems = this.overriddenClasspath;
            prefix = "overridden " + (String)prefix;
        } else {
            effectiveItems = this.additionalClasspath;
            prefix = "additional " + (String)prefix;
        }
        block10: for (int i = 0; i < effectiveItems.size(); ++i) {
            ClasspathItem classpathItem;
            String component = String.format(Locale.ROOT, "%s[%03d]", prefix, i);
            ClasspathItem item = effectiveItems.get(i);
            Objects.requireNonNull(item);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClasspathItem.MavenCoordinateItem.class, ClasspathItem.MinecraftLibraryItem.class, ClasspathItem.PathItem.class}, (Object)classpathItem, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ClasspathItem.MavenCoordinateItem mavenCoordinateItem = (ClasspathItem.MavenCoordinateItem)classpathItem;
                    Object object = mavenCoordinateItem.coordinate();
                    Record coordinate = object;
                    Object uri = object = mavenCoordinateItem.repositoryBaseUrl();
                    if (uri != null) {
                        ck.add(component, String.valueOf(coordinate) + " from " + String.valueOf(uri));
                        continue block10;
                    }
                    ck.add(component, ((MavenCoordinate)coordinate).toString());
                    continue block10;
                }
                case 1: {
                    Record record;
                    Object object = (ClasspathItem.MinecraftLibraryItem)classpathItem;
                    Record library = record = ((ClasspathItem.MinecraftLibraryItem)object).library();
                    MinecraftDownload artifactDownload = ((MinecraftLibrary)library).getArtifactDownload();
                    if (artifactDownload != null) {
                        ck.add(component, ((MinecraftLibrary)library).artifactId() + " [" + artifactDownload.checksum() + "]");
                        continue block10;
                    }
                    ck.add(component, ((MinecraftLibrary)library).artifactId());
                    continue block10;
                }
                case 2: {
                    Path path;
                    Record record = (ClasspathItem.PathItem)classpathItem;
                    Path path2 = path = ((ClasspathItem.PathItem)record).path();
                    ck.addPath(component, path2);
                }
            }
            continue;
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }

    public ExtensibleClasspath copy() {
        ExtensibleClasspath result = new ExtensibleClasspath();
        result.overriddenClasspath = this.overriddenClasspath;
        result.additionalClasspath = new ArrayList<ClasspathItem>(this.additionalClasspath);
        return result;
    }
}

