/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.utils;

import java.util.Map;

public final class Logger {
    private static final Map<Character, String> EMOJI_MAP = Map.of(Character.valueOf('\u2193'), "DL", Character.valueOf('\u267b'), "CACHE", Character.valueOf('\u2713'), "OK", Character.valueOf('\u21b3'), "EXEC");
    public static boolean NO_COLOR;
    public static boolean NO_EMOJIS;
    private static IndeterminateSpinner spinner;

    public static Logger create() {
        return new Logger();
    }

    public void println(String text) {
        this.closeSpinner();
        System.out.println(Logger.cleanText(text));
    }

    private void closeSpinner() {
        if (spinner != null) {
            spinner.end();
            spinner = null;
            System.out.println();
        }
    }

    public IndeterminateSpinner spinner(String message) {
        this.closeSpinner();
        System.out.print(Logger.cleanText(message));
        spinner = new IndeterminateSpinner();
        return spinner;
    }

    private static String cleanText(String text) {
        if (!NO_COLOR && !NO_EMOJIS) {
            return text;
        }
        StringBuilder result = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (NO_COLOR && ch == '\u001b') {
                ++i;
                while (i < text.length() && text.charAt(i) != 'm') {
                    ++i;
                }
                continue;
            }
            if (NO_EMOJIS && ch >= '\u007f') {
                result.append(EMOJI_MAP.getOrDefault(Character.valueOf(ch), "."));
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static class IndeterminateSpinner {
        String[] spinners = new String[]{"", ".", "..", "..."};
        String lastTextPrinted = "";
        int spinnerIndex = 0;

        public IndeterminateSpinner() {
            this.tick();
        }

        public void tick() {
            if (!this.lastTextPrinted.isEmpty()) {
                System.out.print("\b".repeat(this.lastTextPrinted.length()));
            }
            this.lastTextPrinted = this.spinners[++this.spinnerIndex % this.spinners.length];
            System.out.print(this.lastTextPrinted);
        }

        public void end() {
            if (spinner == this) {
                System.out.print("\b".repeat(this.lastTextPrinted.length()));
                this.lastTextPrinted = "";
                spinner = null;
            }
        }
    }
}

