/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.utils;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import net.fabricmc.loom.nativeplatform.LoomNativePlatform;
import net.fabricmc.loom.nativeplatform.LoomNativePlatformException;

public final class FileUtil {
    private static final int MAX_TRIES = 2;

    private FileUtil() {
    }

    public static void atomicMove(Path source, Path destination) throws IOException {
        if (Files.isDirectory(destination, new LinkOption[0])) {
            throw new IOException("Cannot overwrite directory " + String.valueOf(destination));
        }
        try {
            FileUtil.atomicMoveIfPossible(source, destination);
        }
        catch (AccessDeniedException ex) {
            int tries = 0;
            while (true) {
                try {
                    Thread.sleep(10L * (long)tries);
                    FileUtil.atomicMoveIfPossible(source, destination);
                    return;
                }
                catch (AccessDeniedException ex2) {
                    if (tries == 1) {
                        FileUtil.printLockingInfo(ex2);
                        throw ex;
                    }
                }
                catch (InterruptedException exInterrupt) {
                    Thread.currentThread().interrupt();
                    throw ex;
                }
                ++tries;
            }
        }
    }

    private static void printLockingInfo(AccessDeniedException ex) {
        if (ex.getOtherFile() != null && LoomNativePlatform.isSupported()) {
            try {
                List<ProcessHandle> processes = LoomNativePlatform.getProcessesWithLockOn(Paths.get(ex.getOtherFile(), new String[0]));
                System.err.println("File " + ex.getOtherFile() + " is locked by:");
                for (ProcessHandle process : processes) {
                    System.err.println(" " + process.pid() + " " + process.info().command().orElse("<unknown>") + " " + String.valueOf(LoomNativePlatform.getWindowTitlesForPid(process.pid())));
                }
            }
            catch (LoomNativePlatformException loomNativePlatformException) {
                // empty catch block
            }
        }
    }

    private static void atomicMoveIfPossible(Path source, Path destination) throws IOException {
        try {
            Files.move(source, destination, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AtomicMoveNotSupportedException ex) {
            Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

