/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.config.neoforge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;

public record NeoForgeConfig(int spec, @SerializedName(value="mcp") String neoformArtifact, @SerializedName(value="ats") String accessTransformersFolder, @SerializedName(value="patches") String patchesFolder, @SerializedName(value="sources") String sourcesArtifact, @SerializedName(value="universal") String universalArtifact, Map<String, JsonObject> runs, List<MavenCoordinate> libraries, List<String> modules) {
    public static NeoForgeConfig from(ZipFile zipFile) throws IOException {
        byte[] configContent;
        ZipEntry configEntry = zipFile.getEntry("config.json");
        if (configEntry == null || configEntry.isDirectory()) {
            throw new IOException("NeoForm config file config.json not found in " + zipFile.getName());
        }
        try (InputStream in = zipFile.getInputStream(configEntry);){
            configContent = in.readAllBytes();
        }
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)MavenCoordinate.class), MavenCoordinate.TYPE_ADAPTER).create();
        JsonObject root = gson.fromJson((Reader)new StringReader(new String(configContent, StandardCharsets.UTF_8)), JsonObject.class);
        return gson.fromJson((JsonElement)root, NeoForgeConfig.class);
    }
}

