/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cli;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.neoforged.neoform.runtime.utils.AnsiColor;
import net.neoforged.neoform.runtime.utils.HashingUtil;
import net.neoforged.neoform.runtime.utils.Logger;

public class LockManager
implements AutoCloseable {
    private static final Logger LOG = Logger.create();
    private final Path lockDirectory;
    private boolean verbose;

    public LockManager(Path lockDirectory) throws IOException {
        Files.createDirectories(lockDirectory, new FileAttribute[0]);
        this.lockDirectory = lockDirectory;
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    private Path getLockFile(String key) {
        return this.lockDirectory.resolve("_" + HashingUtil.sha1(key) + ".lock");
    }

    public Lock lock(String key) {
        FileLock fileLock;
        FileChannel channel;
        Path lockFile = this.getLockFile(key);
        try {
            channel = FileChannel.open(lockFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to obtain lock for " + key, e);
        }
        Logger.IndeterminateSpinner spinner = null;
        while (true) {
            try {
                fileLock = channel.tryLock();
                if (fileLock != null) {
                    break;
                }
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
            }
            catch (IOException e) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new RuntimeException(e);
            }
            if (spinner == null) {
                spinner = LOG.spinner("Waiting for lock on " + key);
            } else {
                spinner.tick();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                if (spinner != null) {
                    spinner.end();
                }
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        if (spinner != null) {
            spinner.end();
        }
        if (this.verbose) {
            LOG.println(String.valueOf((Object)AnsiColor.MUTED) + " Acquired lock for " + key + String.valueOf((Object)AnsiColor.RESET));
        }
        return new Lock(fileLock);
    }

    @Override
    public void close() {
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static class Lock
    implements AutoCloseable {
        private final FileLock fileLock;

        public Lock(FileLock fileLock) {
            this.fileLock = fileLock;
        }

        @Override
        public void close() {
            try {
                this.fileLock.release();
            }
            catch (IOException ignored) {
                System.err.println("Failed to release lock on " + this.fileLock.channel().toString());
            }
            try {
                this.fileLock.channel().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

