/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.neoforged.neoform.runtime.actions.ExternalJavaToolAction;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;
import org.jetbrains.annotations.Nullable;

public class ApplySourceAccessTransformersAction
extends ExternalJavaToolAction {
    private static final MavenCoordinate JST_TOOL_COORDINATE = MavenCoordinate.parse("net.neoforged.jst:jst-cli-bundle:1.0.37");
    private List<String> accessTransformersData = new ArrayList<String>();
    private List<Path> additionalAccessTransformers = new ArrayList<Path>();
    @Nullable
    private Path parchmentData;

    public ApplySourceAccessTransformersAction() {
        super(JST_TOOL_COORDINATE);
    }

    @Override
    public void run(ProcessingEnvironment environment) throws IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        Collections.addAll(args, "--libraries-list", "{libraries}", "--in-format", "ARCHIVE", "--out-format", "ARCHIVE");
        if (!this.accessTransformersData.isEmpty() || !this.additionalAccessTransformers.isEmpty()) {
            args.add("--enable-accesstransformers");
            for (String dataId : this.accessTransformersData) {
                Path accessTransformers = environment.extractData(dataId);
                Stream<Path> stream = Files.walk(accessTransformers, new FileVisitOption[0]);
                try {
                    stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                        args.add("--access-transformer");
                        args.add(environment.getPathArgument((Path)path));
                    });
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            for (Path path2 : this.additionalAccessTransformers) {
                args.add("--access-transformer");
                args.add(environment.getPathArgument(path2));
            }
        }
        if (this.parchmentData != null) {
            args.add("--enable-parchment");
            args.add("--parchment-mappings=" + environment.getPathArgument(this.parchmentData.toAbsolutePath()));
        }
        Collections.addAll(args, "{input}", "{output}");
        this.setArgs(args);
        super.run(environment);
    }

    @Override
    public void computeCacheKey(CacheKeyBuilder ck) {
        super.computeCacheKey(ck);
        ck.addStrings("access transformers data ids", this.accessTransformersData);
        ck.addPaths("additional access transformers", this.additionalAccessTransformers);
        if (this.parchmentData != null) {
            ck.addPath("parchment data", this.parchmentData);
        }
    }

    public List<String> getAccessTransformersData() {
        return this.accessTransformersData;
    }

    public void setAccessTransformersData(List<String> accessTransformersData) {
        this.accessTransformersData = List.copyOf(accessTransformersData);
    }

    public List<Path> getAdditionalAccessTransformers() {
        return this.additionalAccessTransformers;
    }

    public void setAdditionalAccessTransformers(List<Path> additionalAccessTransformers) {
        this.additionalAccessTransformers = List.copyOf(additionalAccessTransformers);
    }

    @Nullable
    public Path getParchmentData() {
        return this.parchmentData;
    }

    public void setParchmentData(@Nullable Path parchmentData) {
        this.parchmentData = parchmentData;
    }
}

